package com.walker.file;

/**
 * 引擎内部表示一个文件的数据定义。
 * @author 时克英
 * @date 2023-02-10
 */
public interface FileInfo {

    /**
     * 获得文件唯一ID
     * @return
     */
    String getId();

    /**
     * 获得文件URL地址，如果是本地文件则返回绝对路径。
     * @return
     */
    String getUrl();

    /**
     * 返回文件大小
     * @return
     */
    long getFileSize();

    /**
     * 返回文件后缀名，如: .txt
     * @return
     */
    String getFileExt();

    /**
     * 返回文件名字，如: demo.txt
     * @return
     */
    String getFileName();

    /**
     * 返回文件存储类型。
     * @return
     */
    FileStoreType getFileStoreType();

    /**
     * 返回业务ID（分组ID）
     * @return
     */
    String getGroupId();

    /**
     * 数据归属，目前针对商户ID，后续针对所有独立单位ID，因此这里设置为字符串通用化。
     * <p>1.但必须业务统一设置该数据为整形类型，因为数据库字段为：int</p>
     * @return
     * @date 2023-06-05
     */
    String getOwner();

    /**
     * 返回业务分类id，电商系统增加。
     * @return
     * @date 2023-06-05
     */
    int getBusinessType();
}
