package com.walker.file;

import java.io.InputStream;
import java.util.List;

public interface FileOperateEngine {

    /**
     * 关闭引擎。
     */
    void close();

    /**
     * 上传文件操作
     * @param inputStream 文件流
     * @param fileName 文件名称，如: demo.txt
     * @param groupId 分组ID，即: 业务ID
     * @return
     * @throws FileOperateException
     * @date 已废弃，请使用新方法：{@linkplain FileOperateEngine#uploadFile(InputStream, String, String, long, Integer, String)}
     */
    @Deprecated
    FileInfo uploadFile(InputStream inputStream, String fileName, String groupId, long fileSize) throws FileOperateException;

    /**
     * 文件上传
     * @param inputStream
     * @param fileName 文件名称，如: demo.txt
     * @param groupId
     * @param fileSize 文件大小
     * @param businessType 业务分类（PID），为空表示不存在系统默认：-1
     * @param owner 数据归属（商户ID）
     * @return
     * @throws FileOperateException
     * @date 2023-06-09
     */
    FileInfo uploadFile(InputStream inputStream
            , String fileName, String groupId, long fileSize, Integer businessType, String owner) throws FileOperateException;

    /**
     * 多个文件上传
     * @param inputStream
     * @param fileName
     * @param groupId
     * @param fileSize
     * @param businessType
     * @param owner
     * @return 返回多个文件结果集合
     * @throws FileOperateException
     * @date 2023-08-01
     */
    FileInfo[] uploadFile(InputStream[] inputStream
            , String[] fileName, String groupId, long[] fileSize, Integer businessType, String owner) throws FileOperateException;

    FileInfo uploadFile(String filePath, String groupId) throws FileOperateException;

    /**
     * 下载单个文件，该方法适用于中小型文件，大文件需要其他方式处理。
     * @param id 文件id
     * @return 返回文件二进制数据
     * @throws FileOperateException
     */
    byte[] downloadFile(String id) throws FileOperateException;

    /**
     * 返回文件基本信息
     * @param id 文件id
     * @return
     * @date 2023-02-14
     */
    FileInfo getFileInfo(String id);

    /**
     * 返回给定多个文件的集合。
     * @param ids
     * @return
     * @date 2023-02-14
     */
    List<FileInfo> getFileInfoList(List<String> ids);

    /**
     * 返回文件存储类型。
     * @return
     */
    FileStoreType getFileStoreType();

    /**
     * 设置文件存储的根目录，如: /rootFile
     * @param rootName
     */
    void setFileRoot(String rootName);
}
