package com.walker.file;

/**
 * 文件存储类型，新定义。
 * @author 时克英
 * @date 2023-02-10
 */
public enum FileStoreType {

    FileSystem {
        public String getIndex(){
            return INDEX_FS;
        }
    },
    Ftp {
        public String getIndex(){
            return INDEX_FTP;
        }
    },
    Oss {
        public String getIndex(){
            return INDEX_OSS;
        }
    },

    /**
     * 七牛OSS存储
     * @date 2023-05-17
     */
    OssQiNiu {
        public String getIndex(){
            return INDEX_OSS_QI_NIU;
        }
    },

    OssAli {
        public String getIndex(){
            return INDEX_OSS_ALI;
        }
    },

    OssTx {
        public String getIndex(){
            return INDEX_OSS_TX;
        }
    };

    public String  getIndex(){
        throw new AbstractMethodError();
    }

    public static final FileStoreType getType(String index){
        if(index.equalsIgnoreCase(INDEX_FS)){
            return FileSystem;
        } else if(index.equalsIgnoreCase(INDEX_FTP)){
            return Ftp;
        } else if(index.equalsIgnoreCase(INDEX_OSS)){
            return Oss;
        } else if(index.equalsIgnoreCase(INDEX_OSS_QI_NIU)){
            return OssQiNiu;
        } else if(index.equalsIgnoreCase(INDEX_OSS_ALI)){
            return OssAli;
        } else if(index.equalsIgnoreCase(INDEX_OSS_TX)){
            return OssTx;
        } else {
            throw new UnsupportedOperationException("不支持的存储类型:" + index);
        }
    }

    public static final String INDEX_FS = "fs";
    public static final String INDEX_FTP = "ftp";
    public static final String INDEX_OSS = "oss";
    public static final String INDEX_OSS_QI_NIU = "qn";
    public static final String INDEX_OSS_ALI = "ali";
    public static final String INDEX_OSS_TX = "tx";
}
