package com.walker.file.ftp;

import com.walker.file.*;

import java.io.InputStream;

/**
 * 基于FTP文件管理的引擎实现。
 * @author 时克英
 * @date 2023-02-10
 */
public abstract class FtpFileOperateEngine extends AbstractFileOperateEngine {

    @Override
    public FileStoreType getFileStoreType(){
        return FileStoreType.Ftp;
    }

    @Override
    protected FileInfo acquireFileInfo(String fileName) {
        return new DefaultFileInfo();
    }

    @Override
    public void close() {
        super.close();
//        if(this.ftpConnector != null){
//            this.ftpConnector.logout();
//        }
    }

    @Override
    protected void executeUpload(InputStream inputStream, FileInfo fileInfo) throws FileOperateException {
//        FtpConnector ftpConnector = new FtpConnector(this.ftpConfig);
//        try {
//            ftpConnector.connect();
//        } catch (Exception e) {
//            throw new FileOperateException("Ftp无法连接，上传未执行，fileInfo = " + fileInfo.getFileName(), e);
//        }
//
//        // 服务端或远程存放目录，由程序自动生成
//        String directory = this.generateSaveFolder(true);
//
//        StringBuilder url = new StringBuilder(directory);
//        url.append(this.getFileName(fileInfo));
//        ((DefaultFileInfo)fileInfo).setUrl(url.toString());
//
//        logger.debug("上传文件生成目录: " + directory);
//        try{
//            ftpConnector.upload(directory, fileInfo.getFileName(), inputStream);
//        } catch (FtpUploadException ex){
//            throw ex;
//        } finally {
//            if(ftpConnector != null){
//                ftpConnector.logout();
//            }
//        }
        throw new UnsupportedOperationException("系统不再支持ftp上传文件，请使用本地上传或OSS服务！");
    }

    @Override
    protected byte[] executeDownload(FileInfo fileInfo) throws FileOperateException{
//        if(StringUtils.isEmpty(fileInfo.getUrl())){
//            throw new FileOperateException("文件url不存在，fileId=" + fileInfo.getId(), null);
//        }
//        String url = fileInfo.getUrl();
//        String directory = FileUtils.getFilePathWithoutName(url);
//
//        FtpConnector ftpConnector = new FtpConnector(this.ftpConfig);
//        try {
//            ftpConnector.connect();
//        } catch (Exception e) {
//            throw new FileOperateException("Ftp无法连接，下载失败，fileInfo = " + fileInfo.getFileName(), e);
//        }
//
//        try{
//            return ftpConnector.download(directory, this.getFileName(fileInfo));
//        } catch (FtpUploadException ex){
//            throw new FileOperateException("ftp下载文件错误:" + ex.getMessage(), ex);
//        }
        throw new UnsupportedOperationException("系统不再支持ftp上传文件，请使用本地上传或OSS服务！");
    }

    /**
     * 设置ftp信息，并初始化ftp连接器。
     * @param ftpConfig
     * @throws Exception
     */
    public void setFtpConfig(FtpConfig ftpConfig){
        if(ftpConfig == null){
            throw new IllegalArgumentException("FtpConfig 必须设置!");
        }
        this.ftpConfig = ftpConfig;
    }

    private FtpConfig ftpConfig = null;
}
