package com.walker.file.support;

import com.walker.file.FileEngine.StoreType;
import com.walker.file.FileMeta;
import com.walker.infrastructure.utils.FileUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;

public class DefaultFileMeta implements FileMeta {

	private String id;
	private String filename;
	private String contentType;
	private String path;
	StoreType storeType;
	private byte[] content;
	
	private long createTime = 0;
	private String creator;
	
	private String ext;
	
	// 文件绝对路径，带名字，如：d:/logs/2014/8/abcd.doc
	private String absoluteFileName;
	
	private String group;
	
	private long fileSize = 0;
	
	/**
	 * 返回文件的绝对路径，带名字。
	 * @return
	 */
	@Override
	public String getAbsoluteFileName() {
		return absoluteFileName;
	}

	@Override
	public void setAbsoluteFileName(String absoluteFileName) {
		this.absoluteFileName = absoluteFileName;
	}

	public DefaultFileMeta(){
		this.id = String.valueOf(NumberGenerator.getLongSequenceNumber());
		this.createTime = System.currentTimeMillis();
	}
	
	@Override
	public String getId() {
		return id;
	}

	@Override
	public String getFilename() {
		return filename;
	}

	@Override
	public String getContentType() {
		return contentType;
	}

	@Override
	public String getPath() {
		return path;
	}

	@Override
	public StoreType getStoreType() {
		return storeType;
	}

	@Override
	public byte[] getContent() {
		return content;
	}

	@Override
	public long getCreateTime() {
		return createTime;
	}

	@Override
	public String getCreator() {
		return creator;
	}

	@Override
	public void setFilename(String filename) {
		assert (StringUtils.isNotEmpty(filename));
		this.filename = filename;
	}

	@Override
	public void setContentType(String type) {
		assert (StringUtils.isNotEmpty(type));
		this.contentType = type;
	}

	@Override
	public void setPath(String path) {
		assert (StringUtils.isNotEmpty(path));
		this.path = path;
	}

	@Override
	public void setStoreType(StoreType st) {
		assert (st != null);
		this.storeType = st;
	}

	@Override
	public void setContent(byte[] content) {
		assert (content != null);
		this.content = content;
	}

	@Override
	public void setCreator(String creator) {
		assert (StringUtils.isNotEmpty(creator));
		this.creator = creator;
	}

	public String toString(){
		return new StringBuilder().append("id=").append(id)
				.append(", filename=").append(filename)
				.append(", storeType=").append(storeType)
				.append(", createTime=").append(createTime).toString();
	}

	@Override
	public String getFileExt() {
		return ext;
	}

	@Override
	public void setFileExt(String ext) {
//		assert (StringUtils.isNotEmpty(ext));
		this.ext = ext;
	}

	@Override
	public void setId(String id) {
		assert (StringUtils.isNotEmpty(id));
		this.id = id;
	}

	@Override
	public void setCreateTime(long time) {
		if(time > 0)
			this.createTime = time;
	}

	@Override
	public String getGroup() {
		return group;
	}

	@Override
	public void setGroup(String groupId) {
		if(StringUtils.isNotEmpty(groupId)){
			this.group = groupId;
		}
	}

	@Override
	public long getFileSize() {
		return this.fileSize;
	}

	@Override
	public void setFileSize(long size) {
		this.fileSize = size;
	}

	private boolean thumbNails = false;
	private int thumbWidth = 70;
	private int thumbHeight = 70;
	private double thumbQuality = 0.6;
	
	@Override
	public void setThumbNails(boolean thumb) {
		this.thumbNails = thumb;
	}

	@Override
	public void setThumbWithHeight(int width, int height, double quality) {
		if(width >= 480 || height >= 640){
			return;
		}
		this.thumbWidth = width;
		this.thumbHeight = height;
		if(quality < 0 || quality > 1){
			return;
		}
		this.thumbQuality = quality;
	}

	@Override
	public boolean isThumbNails() {
		// 只要是图片，统一都产生缩略图
//		return thumbNails;
		
		thumbNails = this.getIsImage();
		return thumbNails;
	}

	@Override
	public int[] getThumbWidthHeight() {
		return new int[]{this.thumbWidth, this.thumbHeight};
	}

	@Override
	public double getThumbQuality() {
		return this.thumbQuality;
	}

	private Object fileItem;
	
	@Override
	public Object getFileItem() {
		return fileItem;
	}

	@Override
	public void setFileItem(Object fileItem) {
		this.fileItem = fileItem;
	}

	@Override
	public String getThumbNailsName() {
		if(StringUtils.isNotEmpty(path)){
//			StringBuilder thumb = new StringBuilder();
//			thumb.append(path.subSequence(0, path.lastIndexOf(StringUtils.SYMBOL_DOT)));
//			thumb.append("_s.").append(ext);
//			return thumb.toString();
//			return FileUtils.getThumbNailsName(path, ext);
			return FileUtils.getThumbNailsName(path);
		}
		return null;
	}

	@Override
	public boolean getIsImage() {
		if(StringUtils.isNotEmpty(ext)){
			if(ext.equalsIgnoreCase("jpg")
					|| ext.equalsIgnoreCase("jpeg")
					|| ext.equalsIgnoreCase("png")
					|| ext.equalsIgnoreCase("gif") 
					|| ext.equalsIgnoreCase("bmp")){
				return true;
			}
		}
		return false;
	}
	
	public static void main(String[] args){
		DefaultFileMeta fm = new DefaultFileMeta();
		fm.setPath("2016/10/1476712981597_demo_pic.jpg");
		fm.setFileExt("jpg");
		System.out.println(fm.getThumbNailsName() + ", " + fm.getIsImage());
	}
}
