package com.walker.file.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

import javax.imageio.ImageIO;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.walker.infrastructure.utils.StringUtils;

/**
 * 描述：
 * @author 时克英
 * @date 2017年7月26日 下午8:43:50
 */

public class QrcodeUtils {

	/**
     * 根据内容，生成指定宽高、指定格式的二维码图片
     *
     * @param text   内容
     * @param width  宽
     * @param height 高
     * @param format 图片格式
     * @return 生成的二维码图片路径
     * @throws Exception
     */
    public static String generateQRCode(String text, int width, int height, String format, String pathName) throws Exception {
        HashMap<EncodeHintType, Object> hints = new HashMap<>(1);
        hints.put(EncodeHintType.CHARACTER_SET, StringUtils.DEFAULT_CHARSET_UTF8);
        hints.put(EncodeHintType.MARGIN, 0);
        
        BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, width, height, hints);
//        String pathName = "e:/new.png";
//        File outputFile = new File(pathName);
        MatrixToImageWriter.writeToFile(bitMatrix, format, new File(pathName));
        return pathName;
    }
    
    /**
     * 根据内容，生成指定宽高、指定格式的二维码图片，并生成的输出流中
     * @param text
     * @param width
     * @param height
     * @param format 图片格式，如：png
     * @param stream 输出outputStream
     * @throws Exception
     */
    public static final void generateQRCode(String text, int width, int height, String format, OutputStream stream) throws Exception{
    	HashMap<EncodeHintType, Object> hints = new HashMap<>(1);
        hints.put(EncodeHintType.CHARACTER_SET, StringUtils.DEFAULT_CHARSET_UTF8);
        hints.put(EncodeHintType.MARGIN, 0);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, width, height, hints);
        MatrixToImageWriter.writeToStream(bitMatrix, format, stream);
    }
    
    /**
     * 随机生成指定长度的验证码
     *
     * @param length 验证码长度
     * @return 生成的验证码
     */
    public static String generateNumCode(int length) {
        String val = StringUtils.EMPTY_STRING;
        String charStr = "char";
        String numStr = "num";
        Random random = new Random();

        //参数length，表示生成几位随机数
        for (int i = 0; i < length; i++) {

            String charOrNum = random.nextInt(2) % 2 == 0 ? charStr : numStr;
            //输出字母还是数字
            if (charStr.equalsIgnoreCase(charOrNum)) {
                //输出是大写字母还是小写字母
                int temp = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val += (char) (random.nextInt(26) + temp);
            } else if (numStr.equalsIgnoreCase(charOrNum)) {
                val += String.valueOf(random.nextInt(10));
            }
        }
        return val;
    }
    
    /**
     * 解析指定路径下的二维码图片
     *
     * @param filePath 二维码图片路径
     * @return
     */
    public static String parseQRCode(String filePath) {
        String content = StringUtils.EMPTY_STRING;
        try {
            File file = new File(filePath);
            BufferedImage image = ImageIO.read(file);
            LuminanceSource source = new BufferedImageLuminanceSource(image);
            Binarizer binarizer = new HybridBinarizer(source);
            BinaryBitmap binaryBitmap = new BinaryBitmap(binarizer);
            Map<DecodeHintType, Object> hints = new HashMap<>();
            hints.put(DecodeHintType.CHARACTER_SET, StringUtils.DEFAULT_CHARSET_UTF8);
            MultiFormatReader formatReader = new MultiFormatReader();
            Result result = formatReader.decode(binaryBitmap, hints);

            System.out.println("result 为：" + result.toString());
            System.out.println("resultFormat 为：" + result.getBarcodeFormat());
            System.out.println("resultText 为：" + result.getText());
            //设置返回值
            content = result.getText();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }
    
    public static void main(String[] args){
    	try {
            //生成二维码图片，并返回图片路径
//            String pathName = generateQRCode("https://www.baidu.com/home/news/data/newspage?nid=11287040734502055689&n_type=0&p_from=1&dtype=-1", 200, 200, "png", "e:/new.png");
//            System.out.println("生成二维码的图片路径： " + pathName);
//
//            String content = parseQRCode(pathName);
//            System.out.println("解析出二维码的图片的内容为： " + content);
            
//    		StringBuilder sb = new StringBuilder();
//    		sb.append("统一社会信用代码:911100001000124711;\n");
//    		sb.append("名称:中国核工业中原建设有限公司;\n");
//    		sb.append("法定代表人:查小东;\n");
//    		sb.append("成立日期:1992年12月12日;\n");
//    		sb.append("企业信用信息公示系统网址:http://gsxt.haaic.gov.cn/EntInfo.jspx?id=Y2VobHBxcXBvcnFueGp5ZHJn");
//            String pathName = generateQRCode(sb.toString(), 300, 300, "png", "e:/new.png");
//            System.out.println(pathName);
    		
    		// 证书查询1
//    		generateQRCode("http://47.100.13.140/zzcx-1.html", 300, 300, "png", "e:/zzcx-1.png");
    		// 证书查询2
    		generateQRCode("www.walkersoft.net", 158, 158, "png", "d:/shi/downloads/test.png");
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
