/*
 * Decompiled with CFR 0.152.
 */
package com.walker.file;

import com.walker.file.FileEngine;
import com.walker.file.FileMeta;
import com.walker.file.FileOperateException;
import com.walker.file.FileReader;
import com.walker.file.support.SimpleFileMeta;
import com.walker.infrastructure.core.NestedRuntimeException;
import com.walker.infrastructure.utils.FileUtils;
import com.walker.infrastructure.utils.JarDeployer;
import com.walker.infrastructure.utils.LongCalendar;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AbstractFileEngine
implements FileEngine {
    protected static final transient Logger logger = LoggerFactory.getLogger(AbstractFileEngine.class);
    private String fileSystemRoot = FileUtils.getFileSystemRoot();
    private String rootPath = null;
    private boolean storeInWebRoot = true;
    private FileReader fileReader;

    public boolean isStoreInWebRoot() {
        return this.storeInWebRoot;
    }

    public void setStoreInWebRoot(boolean storeInWebRoot) {
        this.storeInWebRoot = storeInWebRoot;
    }

    @Override
    public String getFileStoreRootPath() {
        return this.rootPath;
    }

    @Override
    public List<FileMeta> readFiles(Object request, String fileFormId, FileEngine.StoreType st) throws FileOperateException {
        if (this.fileReader == null) {
            throw new IllegalArgumentException("fileReader is required!");
        }
        try {
            return this.fileReader.read(request, fileFormId, st);
        }
        catch (IOException e) {
            logger.error("reader file from request failed!", (Throwable)e);
            throw new FileOperateException(e.getMessage(), e);
        }
    }

    @Override
    public List<String> writeFiles(List<FileMeta> fileMetas) throws FileOperateException {
        assert (fileMetas != null);
        logger.debug("...... start write files: " + fileMetas.size());
        LinkedList<String> ids = new LinkedList<String>();
        this.doWriteFiles(fileMetas);
        for (FileMeta fm : fileMetas) {
            ids.add(fm.getId());
        }
        return ids;
    }

    private void doWriteFiles(List<FileMeta> fileMetas) throws FileOperateException {
        try {
            for (FileMeta fm : fileMetas) {
                if (fm.getStoreType() == FileEngine.StoreType.FileSystem) {
                    if (StringUtils.isEmpty((String)this.rootPath)) {
                        throw new FileOperateException("rootPath is required!");
                    }
                    this.writeToFileSystem(fm, this.rootPath);
                    this.writeToDatabase(fm);
                    continue;
                }
                if (fm.getStoreType() == FileEngine.StoreType.Database) {
                    this.writeToDatabase(fm);
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }
        catch (Exception ex) {
            throw new FileOperateException(ex.getMessage(), ex);
        }
    }

    @Override
    public FileMeta createEmptyFile(String filename, String mimeType) {
        assert (StringUtils.isNotEmpty((String)filename));
        if (filename.indexOf(46) <= 0) {
            throw new IllegalArgumentException("file not include extention name.");
        }
        int extIndex = filename.lastIndexOf(".");
        SimpleFileMeta fm = new SimpleFileMeta();
        fm.setFilename(filename);
        fm.setFileExt(filename.substring(extIndex + 1));
        fm.setContentType(mimeType);
        String savedPath = LongCalendar.getCurrentMonth();
        String filePath = this.getSavedAbsolutePath(savedPath);
        String newFilename = this.getSavedFilename(filename, fm.getFileExt());
        fm.setPath(savedPath + newFilename);
        fm.setAbsoluteFileName(filePath + newFilename);
        try {
            FileUtils.createEmptyFile((String)(filePath + newFilename));
        }
        catch (IOException e) {
            throw new NestedRuntimeException("create emptyFile failed: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.writeToDatabase(fm);
        }
        catch (Exception e) {
            throw new NestedRuntimeException("save file meta into db failed", (Throwable)e);
        }
        return fm;
    }

    protected abstract String writeToFileSystem(FileMeta var1, String var2) throws IOException;

    protected abstract String writeToDatabase(FileMeta var1) throws Exception;

    protected String getSavedAbsolutePath(String savedPath) {
        String filePath = this.rootPath + savedPath;
        FileUtils.checkDir((String)filePath);
        return filePath;
    }

    protected String getSavedFilename(String resFilename, String ext) {
        String newFilename = "" + NumberGenerator.getLongSequenceNumber() + '.' + ext;
        return newFilename;
    }

    @Override
    public List<FileMeta> listFiles(List<String> ids) throws FileOperateException {
        return null;
    }

    @Override
    public FileMeta getFile(String id) {
        return null;
    }

    @Override
    public File getFileObject(String id) {
        return null;
    }

    @Override
    public void removeFile(String id) throws FileOperateException {
    }

    @Override
    public void setFileStoreRootPath(String rootPath) {
        assert (StringUtils.isNotEmpty((String)rootPath));
        if (this.storeInWebRoot) {
            logger.warn("\u5df2\u7ecf\u8bbe\u7f6e\u6587\u4ef6\u5b58\u653e\u5230web\u76ee\u5f55\u4e2d\uff0c\u5c31\u4e0d\u9700\u8981\u518d\u914d\u7f6e\u5b58\u50a8\u6839\u8def\u5f84\u4e86\uff1a\u8bf7\u67e5\u9605\u53c2\u6570'storeInWebRoot'");
            this.rootPath = this.fileSystemRoot + JarDeployer.webappRootAbsolute + "upload/files/";
        } else {
            this.rootPath = this.fileSystemRoot + rootPath;
        }
        logger.info("\u7cfb\u7edf\u8bbe\u7f6e\u4e86\u6587\u4ef6\u5b58\u50a8\u76ee\u5f55\uff1a" + this.rootPath);
    }

    @Override
    public void setFileReader(FileReader reader) {
        assert (reader != null);
        this.fileReader = reader;
    }
}

