/*
 * Decompiled with CFR 0.152.
 */
package com.walker.file;

import com.walker.file.AbstractFileInfo;
import com.walker.file.FileInfo;
import com.walker.file.FileOperateEngine;
import com.walker.file.FileOperateException;
import com.walker.infrastructure.utils.FileUtils;
import com.walker.infrastructure.utils.LongCalendar;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileOperateEngine
implements FileOperateEngine {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String fileRoot = null;

    @Override
    public void close() {
    }

    @Override
    public byte[] downloadFile(String id) throws FileOperateException {
        if (StringUtils.isEmpty((String)id)) {
            throw new IllegalArgumentException("\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        FileInfo fileInfo = this.getFileInfo(id);
        if (fileInfo == null) {
            throw new FileOperateException("\u6587\u4ef6\u4e0d\u5b58\u5728, fileId=" + id, null);
        }
        return this.executeDownload(fileInfo);
    }

    @Override
    @Deprecated
    public FileInfo uploadFile(InputStream inputStream, String fileName, String groupId, long fileSize) throws FileOperateException {
        return this.uploadFile(inputStream, fileName, groupId, fileSize, null, "-1");
    }

    @Override
    public FileInfo[] uploadFile(InputStream[] inputStream, String[] fileName, String groupId, long[] fileSize, Integer businessType, String owner) throws FileOperateException {
        if (inputStream == null || fileName == null || fileSize == null) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u591a\u4e2a\u6587\u4ef6\uff0c\u53c2\u6570\u4e3a\u7a7a");
        }
        if (inputStream.length != fileName.length || inputStream.length != fileSize.length) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u591a\u4e2a\u6587\u4ef6\uff0cinputStream, fileName, fileSize\u4e2a\u6570\u5fc5\u987b\u4e00\u81f4!");
        }
        int size = inputStream.length;
        FileInfo[] fileInfos = new FileInfo[size];
        for (int i = 0; i < size; ++i) {
            fileInfos[i] = this.uploadFile(inputStream[i], fileName[i], groupId, fileSize[i], businessType, owner);
        }
        return fileInfos;
    }

    @Override
    public FileInfo uploadFile(InputStream inputStream, String fileName, String groupId, long fileSize, Integer businessType, String owner) throws FileOperateException {
        AbstractFileInfo fileInfo = (AbstractFileInfo)this.acquireFileInfo(fileName);
        if (fileInfo == null) {
            throw new IllegalArgumentException("acquireFileInfo()\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5b9e\u73b0\u8be5\u65b9\u6cd5!");
        }
        fileInfo.setId(String.valueOf(NumberGenerator.getLongSequenceNumber()));
        fileInfo.setFileName(fileName);
        fileInfo.setFileExt(FileUtils.getFileExt((String)fileName));
        fileInfo.setFileStoreType(this.getFileStoreType());
        fileInfo.setGroupId(groupId);
        fileInfo.setFileSize(fileSize);
        if (businessType != null) {
            fileInfo.setBusinessType(businessType);
        } else {
            fileInfo.setBusinessType(-1);
        }
        fileInfo.setOwner(owner);
        try {
            this.executeUpload(inputStream, fileInfo);
        }
        catch (Exception ex) {
            throw new FileOperateException("\u4e0a\u4f20\u6587\u4ef6\u9519\u8bef:" + ex.getMessage(), ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            this.writeFileInfo(fileInfo);
        }
        catch (Exception ex) {
            throw new FileOperateException("\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u4fe1\u606f\u9519\u8bef:" + ex.getMessage(), ex);
        }
        return fileInfo;
    }

    @Override
    public FileInfo uploadFile(String filePath, String groupId) throws FileOperateException {
        throw new UnsupportedOperationException("\u4ee3\u7801\u672a\u5b9e\u73b0");
    }

    protected String generateSaveFolder(boolean containRoot) {
        if (StringUtils.isEmpty((String)this.fileRoot)) {
            throw new IllegalArgumentException("\u8bf7\u8bbe\u7f6e\u6839\u76ee\u5f55:fileRoot");
        }
        StringBuilder filePath = new StringBuilder();
        if (containRoot) {
            filePath.append(this.fileRoot);
            if (!this.fileRoot.endsWith("/")) {
                filePath.append("/");
            }
            filePath.append(LongCalendar.getCurrentMonth());
            return filePath.toString();
        }
        return LongCalendar.getCurrentMonth();
    }

    protected String getFileName(FileInfo fileInfo) {
        return fileInfo.getId() + '.' + fileInfo.getFileExt();
    }

    public String getFileRoot() {
        return this.fileRoot;
    }

    @Override
    public void setFileRoot(String fileRoot) {
        this.fileRoot = fileRoot;
    }

    protected abstract FileInfo acquireFileInfo(String var1);

    protected abstract void executeUpload(InputStream var1, FileInfo var2) throws FileOperateException;

    protected abstract void writeFileInfo(FileInfo var1);

    protected abstract byte[] executeDownload(FileInfo var1) throws FileOperateException;
}

