/*
 * Decompiled with CFR 0.152.
 */
package com.walker.file.fs;

import com.walker.file.AbstractFileOperateEngine;
import com.walker.file.DefaultFileInfo;
import com.walker.file.FileInfo;
import com.walker.file.FileOperateException;
import com.walker.file.FileStoreType;
import com.walker.infrastructure.utils.FileCopyUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class FileSystemOperateEngine
extends AbstractFileOperateEngine {
    @Override
    protected FileInfo acquireFileInfo(String fileName) {
        return new DefaultFileInfo();
    }

    @Override
    protected void executeUpload(InputStream inputStream, FileInfo fileInfo) throws FileOperateException {
        String directory = this.generateSaveFolder(false);
        StringBuilder url = new StringBuilder(directory).append(this.getFileName(fileInfo));
        String outputFolder = null;
        String outputFileName = null;
        if (!this.getFileRoot().endsWith("/")) {
            outputFileName = this.getFileRoot() + "/" + url.toString();
            outputFolder = this.getFileRoot() + "/" + directory;
        } else {
            outputFileName = this.getFileRoot() + url.toString();
            outputFolder = this.getFileRoot() + directory;
        }
        this.logger.debug("\u4fdd\u5b58\u6587\u4ef6\u540d\u79f0: " + outputFileName);
        try {
            File outputFolderFile = new File(outputFolder);
            if (!outputFolderFile.exists()) {
                outputFolderFile.mkdirs();
            }
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFileName));
            long fileSize = FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            ((DefaultFileInfo)fileInfo).setFileSize(fileSize);
            ((DefaultFileInfo)fileInfo).setUrl(url.toString());
        }
        catch (IOException e) {
            throw new FileOperateException("\u4fdd\u5b58\u6587\u4ef6\u5230\u7cfb\u7edf\u78c1\u76d8\u9519\u8bef:" + e.getMessage() + ", id=" + fileInfo.getId(), e);
        }
    }

    @Override
    protected byte[] executeDownload(FileInfo fileInfo) throws FileOperateException {
        String outputFileName = null;
        outputFileName = !this.getFileRoot().endsWith("/") ? this.getFileRoot() + "/" + fileInfo.getUrl() : this.getFileRoot() + fileInfo.getUrl();
        File outputFile = new File(outputFileName);
        if (!outputFile.exists()) {
            throw new FileOperateException("\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728\uff0cfileId=" + fileInfo.getId() + ", url=" + fileInfo.getUrl(), null);
        }
        try {
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(outputFile));
            return FileCopyUtils.copyToByteArray((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new FileOperateException("\u4e0b\u8f7d\u6587\u4ef6\u6d41\u51fa\u9519, error=" + e.getMessage(), e);
        }
    }

    @Override
    public FileStoreType getFileStoreType() {
        return FileStoreType.FileSystem;
    }
}

