/*
 * Decompiled with CFR 0.152.
 */
package com.walker.file.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.walker.file.util.BufferedImageLuminanceSource;
import com.walker.file.util.MatrixToImageWriter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Random;
import javax.imageio.ImageIO;

public class QrcodeUtils {
    public static String generateQRCode(String text, int width, int height, String format, String pathName) throws Exception {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>(1);
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.MARGIN, 0);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, width, height, hints);
        MatrixToImageWriter.writeToFile(bitMatrix, format, new File(pathName));
        return pathName;
    }

    public static final void generateQRCode(String text, int width, int height, String format, OutputStream stream) throws Exception {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>(1);
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.MARGIN, 0);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, width, height, hints);
        MatrixToImageWriter.writeToStream(bitMatrix, format, stream);
    }

    public static String generateNumCode(int length) {
        Object val = "";
        String charStr = "char";
        String numStr = "num";
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            String charOrNum;
            String string = charOrNum = random.nextInt(2) % 2 == 0 ? charStr : numStr;
            if (charStr.equalsIgnoreCase(charOrNum)) {
                int temp = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val = (String)val + (char)(random.nextInt(26) + temp);
                continue;
            }
            if (!numStr.equalsIgnoreCase(charOrNum)) continue;
            val = (String)val + String.valueOf(random.nextInt(10));
        }
        return val;
    }

    public static String parseQRCode(String filePath) {
        String content = "";
        try {
            File file = new File(filePath);
            BufferedImage image = ImageIO.read(file);
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)binarizer);
            HashMap<DecodeHintType, String> hints = new HashMap<DecodeHintType, String>();
            hints.put(DecodeHintType.CHARACTER_SET, "UTF-8");
            MultiFormatReader formatReader = new MultiFormatReader();
            Result result = formatReader.decode(binaryBitmap, hints);
            System.out.println("result \u4e3a\uff1a" + result.toString());
            System.out.println("resultFormat \u4e3a\uff1a" + result.getBarcodeFormat());
            System.out.println("resultText \u4e3a\uff1a" + result.getText());
            content = result.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }

    public static void main(String[] args) {
        try {
            QrcodeUtils.generateQRCode("www.walkersoft.net", 158, 158, "png", "d:/shi/downloads/test.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

