package com.walker.file;

import com.walker.file.FileEngine.StoreType;

/**
 * 文件描述信息
 * @author shikeying
 *
 */
@Deprecated
public interface FileMeta {

	String getId();
	
	/**
	 * 文件原始名称，通常是中文名
	 * @return
	 */
	String getFilename();
	
	/**
	 * 返回文件的MIME类型字符串
	 * @return
	 */
	String getContentType();
	
	/**
	 * 返回文件存储在服务器上的相对路径，不包含设置的根路径，如：2014/3/aaa_123456.txt
	 * @return
	 */
	String getPath();
	
	/**
	 * 返回缩略图的相对路径，如：2014/3/aaa_123456_s.jpg
	 * @return
	 */
	String getThumbNailsName();
	
	String getFileExt();
	
	StoreType getStoreType();
	
	byte[] getContent();
	
	long getCreateTime();
	
	String getCreator();
	
	long getFileSize();
	
	void setFileSize(long size);
	
	void setId(String id);
	
	void setFilename(String filename);
	
	void setContentType(String type);
	
	void setPath(String path);
	
	void setStoreType(StoreType st);
	
	void setContent(byte[] content);
	
	void setCreator(String creator);
	
	void setFileExt(String ext);
	
	void setCreateTime(long time);

	void setAbsoluteFileName(String absoluteFileName);

	/**
	 * 返回文件的绝对路径，包含文件名。
	 * @return
	 */
	String getAbsoluteFileName();
	
	/**
	 * 返回文件编组编号，这样便于业务把多个上传文件编为一个组，下载方便。
	 * @return
	 */
	String getGroup();
	
	void setGroup(String groupId);
	
	void setThumbNails(boolean thumb);
	
	/**
	 * 设置缩略图参数：宽高、压缩质量
	 * @param width
	 * @param height
	 * @param quality 压缩质量：0~1,1表示最高质量
	 */
	void setThumbWithHeight(int width, int height, double quality);
	
	/**
	 * 是否产生缩略图，对于图片可能会使用该参数
	 * @return
	 */
	boolean isThumbNails();
	
	int[] getThumbWidthHeight();
	double getThumbQuality();
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// 以下方法是由第三方上传组件使用的，例如：kindeditor等会使用upload包的组件
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/**
	 * 获得第三方传递的特定文件对象，如：kindeditor中的FileItem
	 * @return
	 */
	Object getFileItem();
	
	/**
	 * 设置第三方传递的特定文件对象
	 * @param fileItem
	 */
	void setFileItem(Object fileItem);
	
	/**
	 * 是否图片
	 * @return
	 */
	boolean getIsImage();
}
