/*
 * Decompiled with CFR 0.152.
 */
package com.walker.file.support;

import com.walker.file.FileEngine;
import com.walker.file.FileMeta;
import com.walker.infrastructure.utils.FileUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;

public class DefaultFileMeta
implements FileMeta {
    private String id = String.valueOf(NumberGenerator.getLongSequenceNumber());
    private String filename;
    private String contentType;
    private String path;
    FileEngine.StoreType storeType;
    private byte[] content;
    private long createTime = System.currentTimeMillis();
    private String creator;
    private String ext;
    private String absoluteFileName;
    private String group;
    private long fileSize = 0L;
    private boolean thumbNails = false;
    private int thumbWidth = 70;
    private int thumbHeight = 70;
    private double thumbQuality = 0.6;
    private Object fileItem;

    @Override
    public String getAbsoluteFileName() {
        return this.absoluteFileName;
    }

    @Override
    public void setAbsoluteFileName(String absoluteFileName) {
        this.absoluteFileName = absoluteFileName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public FileEngine.StoreType getStoreType() {
        return this.storeType;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public void setFilename(String filename) {
        assert (StringUtils.isNotEmpty((String)filename));
        this.filename = filename;
    }

    @Override
    public void setContentType(String type) {
        assert (StringUtils.isNotEmpty((String)type));
        this.contentType = type;
    }

    @Override
    public void setPath(String path) {
        assert (StringUtils.isNotEmpty((String)path));
        this.path = path;
    }

    @Override
    public void setStoreType(FileEngine.StoreType st) {
        assert (st != null);
        this.storeType = st;
    }

    @Override
    public void setContent(byte[] content) {
        assert (content != null);
        this.content = content;
    }

    @Override
    public void setCreator(String creator) {
        assert (StringUtils.isNotEmpty((String)creator));
        this.creator = creator;
    }

    public String toString() {
        return "id=" + this.id + ", filename=" + this.filename + ", storeType=" + (Object)((Object)this.storeType) + ", createTime=" + this.createTime;
    }

    @Override
    public String getFileExt() {
        return this.ext;
    }

    @Override
    public void setFileExt(String ext) {
        this.ext = ext;
    }

    @Override
    public void setId(String id) {
        assert (StringUtils.isNotEmpty((String)id));
        this.id = id;
    }

    @Override
    public void setCreateTime(long time) {
        if (time > 0L) {
            this.createTime = time;
        }
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String groupId) {
        if (StringUtils.isNotEmpty((String)groupId)) {
            this.group = groupId;
        }
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public void setFileSize(long size) {
        this.fileSize = size;
    }

    @Override
    public void setThumbNails(boolean thumb) {
        this.thumbNails = thumb;
    }

    @Override
    public void setThumbWithHeight(int width, int height, double quality) {
        if (width >= 480 || height >= 640) {
            return;
        }
        this.thumbWidth = width;
        this.thumbHeight = height;
        if (quality < 0.0 || quality > 1.0) {
            return;
        }
        this.thumbQuality = quality;
    }

    @Override
    public boolean isThumbNails() {
        this.thumbNails = this.getIsImage();
        return this.thumbNails;
    }

    @Override
    public int[] getThumbWidthHeight() {
        return new int[]{this.thumbWidth, this.thumbHeight};
    }

    @Override
    public double getThumbQuality() {
        return this.thumbQuality;
    }

    @Override
    public Object getFileItem() {
        return this.fileItem;
    }

    @Override
    public void setFileItem(Object fileItem) {
        this.fileItem = fileItem;
    }

    @Override
    public String getThumbNailsName() {
        if (StringUtils.isNotEmpty((String)this.path)) {
            return FileUtils.getThumbNailsName((String)this.path);
        }
        return null;
    }

    @Override
    public boolean getIsImage() {
        return StringUtils.isNotEmpty((String)this.ext) && (this.ext.equalsIgnoreCase("jpg") || this.ext.equalsIgnoreCase("jpeg") || this.ext.equalsIgnoreCase("png") || this.ext.equalsIgnoreCase("gif") || this.ext.equalsIgnoreCase("bmp"));
    }

    public static void main(String[] args) {
        DefaultFileMeta fm = new DefaultFileMeta();
        fm.setPath("2016/10/1476712981597_demo_pic.jpg");
        fm.setFileExt("jpg");
        System.out.println(fm.getThumbNailsName() + ", " + fm.getIsImage());
    }
}

