package com.walker.async;

import java.util.List;

/**
 * 异步队列消费者接口定义。
 * @author Administrator
 *
 */
public interface Consumer {

	/**
	 * 获得给定名字队列中，元素总数
	 * @return
	 */
	long getQueueSize();

	/**
	 * 从队列弹出指定数量消息，如果全部，end = -1
	 * @param end 弹出消息数量，如果全部，end = -1
	 * @return
	 */
	List<?> popList(long end, long defaultValue);

	void consume(List<?> dataList) throws ConsumerException;

	void consume(Object data) throws ConsumerException;

	String getKey();
}
