package com.walker.async;

import java.util.List;

/**
 * 生产者接口定义，对于想异步处理发送、接收数据的场景可以使用该方式。</p>
 * 如：日志异步记录、公告查看异步记录等场景中。
 * @author Administrator
 *
 */
public interface Producer {

	/**
	 * 生成一条数据，或者发送一条数据
	 * @param key 发送到的队列名称
	 * @param data 发送数据
	 * @param parameter 其他必要参数
	 * @throws ProduceException
	 */
	@Deprecated
	void product(String key, Object data, Object parameter) throws ProduceException;

	/**
	 * 批量向redis发送数据集合
	 * @param key 发送到的队列名称
	 * @param datas 发送的集合
	 * @param parameter 其他必要参数
	 * @throws ProduceException
	 */
	void push(String key, List<String> datas, Object parameter) throws ProduceException;

	void push(String key, String data, Object parameter) throws ProduceException;

	/**
	 * 清空给定的队列数据
	 * @param key
	 * @return
	 */
	long clearQueueData(String key);
}
