package com.walker.db;

public enum DatabaseType {

	ORACLE{
		public int getTypeIndex(){
			return ORACLE_TYPE;
		}
		public String toString(){
			return NAME_ORACLE;
		}
	},
	MYSQL{
		public int getTypeIndex(){
			return MYSQL_TYPE;
		}
		public String toString(){
			return NAME_MYSQL;
		}
	},
	SQLSERVER{
		public int getTypeIndex(){
			return SQLSERVER_TYPE;
		}
		public String toString(){
			return NAME_SQLSERVER;
		}
	},
	POSTGRES{
		public int getTypeIndex(){
			return POSTGRES_TYPE;
		}
		public String toString(){
			return NAME_POSTGRES;
		}
	},
	DERBY{
		public int getTypeIndex(){
			return DERBY_TYPE;
		}
		public String toString(){
			return NAME_DERBY;
		}
	},
	SQLITE{
		public int getTypeIndex(){
			return SQLITE_TYPE;
		}
		public String toString(){
			return NAME_SQLITE;
		}
	},

	/**
	 * 达梦数据库类型。
	 * @date 2023-03-02
	 */
	DAMENG {
		public int getTypeIndex(){
			return DAMENG_TYPE;
		}
		public String toString(){
			return NAME_DAMENG;
		}
	};

	static final int ORACLE_TYPE = 1;
	static final int MYSQL_TYPE = 2;
	static final int SQLSERVER_TYPE = 3;
	static final int POSTGRES_TYPE = 4;
	static final int SQLITE_TYPE = 5;
	static final int DERBY_TYPE = 0;
	static final int DAMENG_TYPE = 6;

	public static final String NAME_MYSQL = "mysql";
	public static final String NAME_ORACLE = "oracle";
	public static final String NAME_SQLSERVER = "sqlserver";
	public static final String NAME_DERBY = "derby";
	public static final String NAME_POSTGRES = "postgres";
	public static final String NAME_POSTGRESQL = "postgresql";
	public static final String NAME_SQLITE = "sqlite";
	public static final String NAME_DAMENG = "dm";


	/**
	 * 返回数据库类型的索引值，系统定义了常用数据库的索引值。
	 * <pre>
	 * 枚举类型如下：
	 * ORACLE, MYSQL, SQLSERVER
	 * </pre>
	 * @return
	 */
	public int getTypeIndex(){
		throw new AbstractMethodError();
	}

	public String toString(){
		throw new AbstractMethodError();
	}

	public static DatabaseType getType(int index){
		if(index == ORACLE_TYPE){
			return ORACLE;
		} else if(index == MYSQL_TYPE){
			return MYSQL;
		} else if(index == SQLSERVER_TYPE){
			return SQLSERVER;
		} else if(index == DERBY_TYPE){
			return DERBY;
		} else if(index == POSTGRES_TYPE){
			return POSTGRES;
		} else if(index == SQLITE_TYPE){
			return SQLITE;
		} else if(index == DAMENG_TYPE){
			return DAMENG;
		} else
			throw new IllegalArgumentException("unsupported type: " + index);
	}
}
