package com.walker.db;

import com.walker.infrastructure.utils.StringUtils;

/**
 * 数据库字段排序对象
 * @author shikeying
 *
 */
public abstract class Sorts {

	public static final String NAME_ASC = "asc";
	public static final String NAME_DESC = "desc";
	
	public static Sort ASC(){
		return new AscSort();
	}
	
	public static Sort DESC(){
		return new DescSort();
	}
	
	public interface Sort {
		/**
		 * 获得排序顺序关键词，如：asc/desc
		 * @return
		 */
		String getValue();
		
		/**
		 * 返回排序的字段名称
		 * @return
		 */
		String getField();
		Sort setField(String name);
		
		boolean isAsc();
	}
	
	private static class AscSort implements Sort{

		private String fieldName;
		
		@Override
		public String getValue() {
			// TODO Auto-generated method stub
			return NAME_ASC;
		}

		@Override
		public String getField() {
			// TODO Auto-generated method stub
			return this.fieldName;
		}

		@Override
		public Sort setField(String name) {
			// TODO Auto-generated method stub
			assert (StringUtils.isNotEmpty(name));
			this.fieldName = name;
			return this;
		}

		@Override
		public boolean isAsc() {
			// TODO Auto-generated method stub
			return true;
		}
	}
	
	private static class DescSort implements Sort{

		private String fieldName;
		
		@Override
		public String getValue() {
			// TODO Auto-generated method stub
			return NAME_DESC;
		}

		@Override
		public String getField() {
			// TODO Auto-generated method stub
			return this.fieldName;
		}

		@Override
		public Sort setField(String name) {
			// TODO Auto-generated method stub
			assert (StringUtils.isNotEmpty(name));
			this.fieldName = name;
			return this;
		}

		@Override
		public boolean isAsc() {
			// TODO Auto-generated method stub
			return false;
		}
	}
	
	public static void main(String[] args){
		Sorts.ASC().setField("sxh");
	}
}
