package com.walker.db;

import java.io.Serializable;

/**
 * 数据库中表基本信息定义
 * @author shikeying
 * @date 2016年2月22日
 *
 */
public class TableInfo implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8585636177565444078L;

	private String name;
	private String summary;
	private long rows = 0;
	
	private String tableSpace;
	private String status;
	private long avgRowLen = 0;
	private long blocks = 0;
	private String lastAnalyzed;
	
	public String getTableSpace() {
		return tableSpace;
	}
	public void setTableSpace(String tableSpace) {
		this.tableSpace = tableSpace;
	}
	public String getStatus() {
		return status;
	}
	public void setStatus(String status) {
		this.status = status;
	}
	public long getAvgRowLen() {
		return avgRowLen;
	}
	public void setAvgRowLen(long avgRowLen) {
		this.avgRowLen = avgRowLen;
	}
	public long getBlocks() {
		return blocks;
	}
	public void setBlocks(long blocks) {
		this.blocks = blocks;
	}
	public String getLastAnalyzed() {
		return lastAnalyzed;
	}
	public void setLastAnalyzed(String lastAnalyzed) {
		this.lastAnalyzed = lastAnalyzed;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getSummary() {
		return summary;
	}
	public void setSummary(String summary) {
		this.summary = summary;
	}
	
	/**
	 * 表中记录数
	 * @return
	 */
	public long getRows() {
		return rows;
	}
	public void setRows(long rows) {
		this.rows = rows;
	}
	
	@Override
	public String toString(){
		return new StringBuilder().append("tableInfo:[name=").append(name)
				.append(", summary=").append(summary)
				.append(", rows=").append(rows)
				.append("]").toString();
	}
}
