package com.walker.db.page;

import java.util.ArrayList;
import java.util.List;

public class GenericPager<T> extends AbstractPager {

	protected List<T> datas;
	
	public GenericPager(List<T> datas, int pageIndex, int pageSize, int totalRows){
		super(pageIndex, pageSize, totalRows);
		setDatas(datas);
	}
	
	@Override
	protected Class<?> buildData() {
		return List.class;
	}

	public GenericPager<T> setDatas(List<T> datas){
		if(this.datas != null){
			throw new IllegalStateException("datas is not empty.");
		}
		if(datas != null){
			this.datas = datas;
		}
		return this;
	}

	/**
	 * 得到泛型格式的数据集合
	 * @return
	 */
	public List<T> getDatas() {
		return datas;
	}

	@Override
	public List<Object> getDatasObject() {
		if(datas == null) return null;
		List<Object> result = new ArrayList<Object>(datas.size());
		for(T obj : datas){
			result.add(obj);
		}
		return result;
	}
	
	public static void main(String[] args){
//		GenericPager<Connection> pager = ListPageContext.createGenericPager(4, 10, 33);
//		System.out.println("start = " + pager.getFirstRowIndexInPage() + ", end = " + pager.getEndRowIndexPage());
	}
}
