package com.walker.db.page;

import com.walker.db.Sorts;
import com.walker.infrastructure.utils.StringUtils;

/**
 * 前端分页搜索条件对象使用。
 * @author 时克英
 * @date 2022-11-16
 */
public class PageSearch {

    /**
     * 当前记录起始索引
     */
    @Deprecated
//    public static final String PAGE_NUM = "pageIndex";
    public static final String PAGE_NUM = "pageNum";

    /**
     * 每页显示记录数
     */
    @Deprecated
    public static final String PAGE_SIZE = "pageSize";

    /**
     * 使用新前端的分页参数定义，电商。
     * @date 2023-05-18
     */
    public static final String KEY_PAGE = "page";
    public static final String KEY_PAGE_LIMIT = "limit";

    /**
     * 排序列
     */
    @Deprecated
    public static final String ORDER_BY_COLUMN = "orderByColumn";

    /**
     * 排序的方向 "desc" 或者 "asc".
     */
    public static final String IS_ASC = "isAsc";

    private int pageIndex = 1;

    private int pageSize = 20;

    /** 排序列 */
    private String orderByColumn;

//    /** 分页参数合理化，配合若依前端, 2022-11-16 */
//    private Boolean reasonable = true;

    private String orderAsc = Sorts.NAME_ASC;

    public int getPageIndex() {
        return pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByColumn() {
        return orderByColumn;
    }

    public void setOrderByColumn(String orderByColumn) {
        this.orderByColumn = orderByColumn;
    }

//    public Boolean getReasonable() {
//        return reasonable;
//    }
//    public void setReasonable(Boolean reasonable) {
//        this.reasonable = reasonable;
//    }

    public String getOrderAsc() {
        return orderAsc;
    }

    @Deprecated
    public void setOrderAsc(String orderAsc) {
        if (StringUtils.isNotEmpty(orderAsc)) {
            // 兼容前端排序类型
            if ("ascending".equals(orderAsc)) {
                this.orderAsc = Sorts.NAME_ASC;
            }
            else if ("descending".equals(orderAsc)) {
                this.orderAsc = "desc";
            }
            this.orderAsc = orderAsc;
        }
    }

    public String getOrderBy() {
        if (StringUtils.isEmpty(orderByColumn)) {
            return StringUtils.EMPTY_STRING;
        }
        return StringUtils.toUnderScoreCase(orderByColumn) + " " + this.orderAsc;
    }

}
