package com.walker.db.page;

import java.util.List;

/**
 * 可分页的规范定义
 * @author shikeying
 * @date 2013-9-25
 */
public interface Pager {

	public static final int DEFAULT_PAGE_INDEX = 1;
	
	public static final int DEFAULT_PAGE_SIZE  = ListPageContext.DEFAULT_PAGE_SIZE;
	
	/* 默认的总页数 */
	public static final int DEFAULT_PAGE_COUNT = 1;
	
	/* 默认的总记录数 */
	public static final int DEFAULT_TOTAL_ROWS = 0;

	/**
	 * 是否还有上一页，如果有返回<code>true</code>
	 * @return
	 */
	public abstract boolean hasPreviousPage();

	/**
	 * 是否还有下一页，如果有返回<code>true</code>
	 * @return
	 */
	public abstract boolean hasNextPage();

	/**
	 * 返回当前页第一条数据索引值，第一页第一条记录为[0]
	 * @return
	 */
	public abstract long getFirstRowIndexInPage();

	/**
	 * 每页显示多少记录
	 * @return
	 */
	public abstract int getPageSize();

	/**
	 * 当前页码
	 * @return
	 */
	public abstract int getPageIndex();

	/**
	 * 设置总记录数
	 * @param totalRows
	 */
	public abstract void setTotalRows(final long totalRows);

	/**
	 * 返回总记录数
	 * @return
	 */
	public abstract long getTotalRows();

	/**
	 * 返回总页数
	 * @return
	 */
	public abstract int getPageCount();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isEmpty();
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/**
	 * 返回业务对象集合
	 * @return
	 */
	List<Object> getDatasObject();

	long getEndRowIndexPage();
	
//	List<Map<String, Object>> getDatasMap();
//	
//	List<JSONObject> getDatasJson();
	
	
}
