package com.walker.di;

import com.walker.infrastructure.utils.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractErrorWriter implements ErrorWriter{

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

//    @Override
//    public void write(Map<String, String> data) {
//
//    }
//
//    @Override
//    public void close() {
//
//    }

    protected String[] cloneColumns(List<String> fieldNames){
        String[] columns = new String[fieldNames.size()+1];
        for(int i=0; i< fieldNames.size(); i++){
            columns[i] = fieldNames.get(i);
        }
        // 增加一列: 错误原因
        columns[fieldNames.size()] = Constants.ERROR_COLUMN_NAME;
        return columns;
    }

    /**
     * 把一行数据(使用 KeyValue 对象表示)转换成普通 Map
     * @param data
     * @return
     * @date 2023-02-08
     */
    protected Map<String, String> toMap(List<KeyValue<String, String>> data){
        // 数据转 Map
        Map<String, String> map = new HashMap<>();
        for(KeyValue<String, String> kv : data){
            map.put(kv.getKey(), kv.getValue());
        }
        return map;
    }
}
