package com.walker.di;

import com.walker.infrastructure.utils.KeyValue;

import java.util.List;

/**
 * 错误记录器定义，
 * @author 时克英
 * @date 2023-02-02
 */
public interface ErrorWriter {

    /**
     * 写入错误记录
     * @param data 导入记录
     * @param error 错误原因
     */
//    void write(Map<String, String> data, String error);
    void write(List<KeyValue<String, String>> data, String error);

    /**
     * 关闭操作，如:关闭文件流
     */
    void close();
}
