package com.walker.di;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 数据更新结果对象，里面包含: 要写入和更新的数据，分开好处理。
 * @author 时克英
 * @date 2023-02-03
 */
public class UpdateResult {

    private List<String> updateColumnNames = null;
    private List<String> whereColumnNames = null;

    private List<Map<String, Object>> insertList = null;
    private List<Map<String, Object>> updateList = null;

    public void addInsert(Map<String, Object> map){
        if(this.insertList == null){
            this.insertList = new ArrayList<>();
        }
        this.insertList.add(map);
    }
    public void addUpdate(Map<String, Object> map){
        if(this.updateList == null){
            this.updateList = new ArrayList<>();
        }
        this.updateList.add(map);
    }

    public void setInsertList(List<Map<String, Object>> insertList) {
        this.insertList = insertList;
    }

    public void setUpdateList(List<Map<String, Object>> updateList) {
        this.updateList = updateList;
    }

    /**
     * 获得要更新记录的条件字段名称集合，如: where card = ? and mobile = ? <p></p>
     * 目前多条件仅支持 and 操作，暂未支持 or。
     * @return
     */
    public List<String> getWhereColumnNames() {
        return whereColumnNames;
    }

    public void setWhereColumnNames(List<String> whereColumnNames) {
        this.whereColumnNames = whereColumnNames;
    }

    /**
     * 获得需要更新记录的字段名集合,如: set phone=? and name=?
     * @return
     */
    public List<String> getUpdateColumnNames() {
        return updateColumnNames;
    }

    public void setUpdateColumnNames(List<String> updateColumnNames) {
        this.updateColumnNames = updateColumnNames;
    }

    /**
     * 返回 写入数据集合。
     * @return
     */
    public List<Map<String, Object>> getInsertList(){
        return this.insertList;
    }

    /**
     * 返回 更新数据集合。
     * @return
     */
    public List<Map<String, Object>> getUpdateList(){
        return this.updateList;
    }
}
