package com.walker.di;

/**
 * 更新类型，在导入数据时，对于已有数据使用的更新策略。
 * @author 时克英
 * @date 2023-02-05
 */
public enum UpdateType {

    Ignore {
        public int getIndex(){
            return INDEX_IGNORE;
        }
    },
    Override {
        public int getIndex(){
            return INDEX_OVERRIDE;
        }
    };

    public int getIndex(){
        throw new AbstractMethodError();
    }

    public static final UpdateType getType(int index){
        if(index == INDEX_IGNORE){
            return Ignore;
        } else if(index == INDEX_OVERRIDE){
            return Override;
        } else {
            throw new UnsupportedOperationException("不支持的更新类型:" + index);
        }
    }

    public static final int INDEX_IGNORE = 0;
    public static final int INDEX_OVERRIDE = 1;
}
