package com.walker.di.support;

import com.walker.di.AbstractDataImportor;

import java.io.IOException;
import java.io.InputStream;

public abstract class InputStreamDataImportor extends AbstractDataImportor {

    protected void checkSource(Object source){
        if(!(source instanceof InputStream)){
            throw new IllegalArgumentException("source必须是:InputStream");
        }
    }

    /**
     * 释放加载的原始导入文件流。
     * @param source
     * @date 2023-02-07
     */
    protected void releaseSource(Object source){
        if(source == null){
            return;
        }
        if(source instanceof InputStream){
            InputStream inputStream = (InputStream)source;
            try {
                inputStream.close();
            } catch (IOException e) {
                logger.error("释放导入原始流出错, source.close():" + e.getMessage());
            }
        }
    }
}
