package com.walker.infrastructure;

/**
 * 应用系统回调接口定义。</p>
 * 在应用程序中，会定义很多业务回调接口，此接口是基础接口。<br>
 * 系统在启动时，会加载并过滤该接口，以便保持引用该接口，提供更方便的调用。
 * @author shikeying
 * @date 2014-11-25
 *
 */
public interface ApplicationCallback {

    /**
     * 是否支持多个实现对象。<p></p>
     * 例如: 用户管理仅支持一个回调实现，但登录却包含多种实现形式，因此添加该特性以区分。
     * @return
     * @date 2023-01-26
     */
    boolean supportMultiple();
}
