package com.walker.infrastructure;

import com.walker.infrastructure.core.NestedCheckedException;

/**
 * 应用程序的基础异常定义，业务应用的所有特定异常必须继承该对象。
 * @author shikeying
 * @date 2014-3-12
 *
 */
public class ApplicationException extends NestedCheckedException {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2709415537392548643L;

	private static final String ERROR_1 = "应用程序发生已知错误,代码:";
	
	private String code;
	
	public String getCode() {
		return code;
	}

	public ApplicationException(){
		super(ERROR_1);
	}
	
	public ApplicationException(String msg){
		super(msg);
	}
	
	public ApplicationException(String msg, Throwable cause){
		super(msg, cause);
	}
	
	public ApplicationException(String code, String msg){
		super(msg);
		this.code = code;
	}
	
	public ApplicationException(String code, String msg, Throwable cause){
		super(msg, cause);
		this.code = code;
	}
}
