package com.walker.infrastructure.arguments;

import com.walker.infrastructure.utils.StringUtils;

/**
 * 可变参数类型定义，系统支持常用的几种格式，与<code>JAVA</code>系统类似。
 * @author shikeying
 *
 */
public enum VariableType {

	String{
		public String getTypeName(){
			return DEF_STRING;
		}
	},
	Integer{
		public String getTypeName(){
			return DEF_INTEGER;
		}
	},
	Long{
		public String getTypeName(){
			return DEF_LONG;
		}
	},
	Boolean{
		public String getTypeName(){
			return DEF_BOOLEAN;
		}
	},
	Float{
		public String getTypeName(){
			return DEF_FLOAT;
		}
	},
	Double{
		public String getTypeName(){
			return DEF_DOUBLE;
		}
	};
	
	public static final String DEF_STRING  = "string";
	public static final String DEF_INTEGER = "integer";
	public static final String DEF_LONG = "long";
	public static final String DEF_BOOLEAN = "boolean";
	public static final String DEF_FLOAT   = "float";
	public static final String DEF_DOUBLE   = "double";

	public String getTypeName(){
		throw new AbstractMethodError();
	}
	
	public static final VariableType getType(String defType){
		assert (StringUtils.isNotEmpty(defType));
		if(defType.equals(DEF_STRING)){
			return String;
		} else if(defType.equals(DEF_INTEGER)){
			return Integer;
		} else if(defType.equals(DEF_BOOLEAN)){
			return Boolean;
		} else if(defType.equals(DEF_FLOAT)){
			return Float;
		} else if(defType.equals(DEF_LONG)){
			return Long;
		}else if(defType.equals(DEF_DOUBLE)){
			return Double;
		} else
			throw new IllegalArgumentException("unknown VariableType: " + defType);
	}
}
