package com.walker.infrastructure.core;

import java.io.InputStream;


/**
 * DOM对象转换器
 * @author MikeShi
 *
 * @param <T>
 */
public interface DomParser<T> {

	/**
	 * 输入xml字符串，返回Dom对象，因为存在多种dom规范，所以返回指定的类型
	 * @param xml
	 * @return
	 * @date 2012-7-13
	 */
	T getDocumentFromXml(String xml);

	/**
	 * 输入xml文件流，返回Dom对象，因为存在多种dom规范，所以返回指定的类型
	 * @param inputStream
	 * @return
	 * @date 2012-7-13
	 */
	T getDocumentFromStream(InputStream inputStream);
	
	/**
	 * 是否支持给定的类型
	 * @param clazz：给定类型
	 * @return
	 * @date 2012-7-9
	 */
	boolean isSupported(Class<Object> clazz);
}
