package com.walker.infrastructure.core.domx;

import com.walker.infrastructure.core.DomParser;
import com.walker.infrastructure.utils.WorkingTimeTester;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.io.SAXReader;
import org.dom4j.io.STAXEventReader;

import javax.xml.stream.XMLStreamException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;


public class Dom4jParser implements DomParser<Document> {

	private final DocumentFactory factory = new DocumentFactory();
	private STAXEventReader stax = new STAXEventReader(factory);
	
	private SAXReader saxReader = new SAXReader();
	
	public Document getDocumentFromXml(String xml){
		
		if (xml == null) {
			return null;
		}

		Document doc = null;
		Reader sreader = null;
		
		try {
			sreader = new StringReader(xml);
			doc = stax.readDocument(sreader);

		} catch (XMLStreamException e) {
			throw new XmlParseException(xml);
			
		} finally {
			try {
				if (sreader != null) {
					sreader.close();
				}
			} catch (Exception e2) {
			}
//			sreader = null;
		}
		return doc;
	}

	public boolean isSupported(Class<Object> clazz) {
		return false;
	}

	public Document getDocumentFromStream(InputStream inputStream) {
		try {
			return saxReader.read(inputStream);
		} catch (DocumentException e) {
			throw new RuntimeException("Document create error!");
		}
	}
	
	public static void main(String[] args){
		final StringBuilder XML_INSERT = new StringBuilder();
		XML_INSERT.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
		XML_INSERT.append("<Root>");
		XML_INSERT.append("<ReqType id=\"myid\">input</ReqType>");
		XML_INSERT.append("<SessionID>会话ID</SessionID>");
		XML_INSERT.append("<Version>当前数据录入操作协议版本</Version>");
		XML_INSERT.append("<TransactionType>事务类型(默认为1)</TransactionType>");
		XML_INSERT.append("</Root>");
		
		final Dom4jParser parser = new Dom4jParser();
//		Document document = null;
		for(int i=0; i<10; i++){
			new Thread(){
				public void run(){
					WorkingTimeTester wtt = new WorkingTimeTester();
					Document document = parser.getDocumentFromXml(XML_INSERT.toString());
					wtt.stop();
					System.out.println("============ " + document.toString());
				}
			}.start();
		}
	}
}
