package com.walker.infrastructure.core.io;

public interface ResourceLocate {

	/**
	 * 设置资源文件是否在JAR包中
	 * @param boo
	 * @date 2012-7-31
	 */
	void setResourceInJar(boolean boo);
	
	/**
	 * 返回资源文件是否在JAR包中，如果是为TRUE
	 * @return
	 * @date 2012-7-31
	 */
	boolean resourceInJar();
	
	/**
	 * 设置配置资源文件的路径
	 * <p/>有两种方式设置值，此方法为第一种，直接设置配置文件路径，此路径支持绝对路径和classpath两种
	 * <p/>1、例如：file:d:/conf/myconfig.xml; classpath:conf/myconfig.xml
	 * <p/>2、另一种是通过构造方法，直接传递AttributeResourceReplacer对象，此对象的抽象类中也可以设置配置文件路径，如下：
	 * <pre>
	 *  &lt;bean id="xmlConfigAttributeResourceSolver"
	 *		class="com.xdja.framework.core.attribute.XmlAttributeResourceSolver" p:location="classpath:sysConfig.xml">
	 *	&lt;/bean&gt;
	 * 
	 * </pre>
	 * @param location
	 * @date 2012-7-30
	 */
	void setLocation(String location);
}
