package com.walker.infrastructure.time;

import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;

public class TimeRangeUtils {

    /**
     * 返回选择解析过的时间范围，该方法包含了多种范围定义。
     * @param data 时间范围选择参数，参考：{@linkplain TimeConstants}
     * @return
     * @date 2023-06-02
     */
    public static final TimeRange getDateLimit(String data){
        if(StringUtils.isEmpty(data)){
            return null;
        }
        Long startTime = null;
        Long endTime = null;

        if(data.equals(TimeConstants.SEARCH_DATE_DAY)){
            startTime = getCurrentDateTimeStart();
            endTime = startTime + 235959;

        } else if (data.equals(TimeConstants.SEARCH_DATE_YESTERDAY)) {
            startTime = DateUtils.getAfterLongTime(getCurrentDateTimeStart(), -1);
            endTime = startTime + 235959;

        } else if (data.equals(TimeConstants.SEARCH_DATE_LATELY_7)) {
            startTime = DateUtils.getAfterLongTime(getCurrentDateTimeStart(), -6);
//            endTime = getCurrentDateTimeStart() + 235959;

        } else if (data.equals(TimeConstants.SEARCH_DATE_LATELY_30)) {
            startTime = DateUtils.getAfterLongTime(getCurrentDateTimeStart(), -30);
//            endTime = getCurrentDateTimeStart() + 235959;

        } else if(data.equals(TimeConstants.SEARCH_DATE_WEEK)){
            startTime = DateUtils.getCurrentWeekStartDay();
            endTime = DateUtils.getAfterLongTime(startTime, 6) + 235959;

        } else if (data.equals(TimeConstants.SEARCH_DATE_PRE_WEEK)) {
            startTime = DateUtils.getAfterLongTime(DateUtils.getCurrentWeekStartDay(), -7);
            // 上周结束时间
            endTime = DateUtils.getAfterLongTime(startTime, 6) + 235959;

        } else if (data.equals(TimeConstants.SEARCH_DATE_MONTH)) {
            startTime = DateUtils.getCurrentMonthStartDay();
            endTime = DateUtils.getCurrentMonthEndDay();

        } else if (data.equals(TimeConstants.SEARCH_DATE_PRE_MONTH)) {
            startTime = DateUtils.getLastMonthStartDay();
            endTime = DateUtils.getLastMonthEndDay();

        } else if (data.equals(TimeConstants.SEARCH_DATE_YEAR)) {
            startTime = DateUtils.getCurrentYearStartDay();
            endTime = DateUtils.getCurrentYearEndDay();

        } else if (data.equals(TimeConstants.SEARCH_DATE_PRE_YEAR)) {
            startTime = DateUtils.getLastYearStartDay();
            endTime = DateUtils.getLastYearEndDay();

        } else {
            // 时间范围，如：2023-06-02,2023-06-05
            String[] timeArray = StringUtils.commaDelimitedListToStringArray(data);
            if(timeArray == null || timeArray.length == 0){
                throw new IllegalArgumentException("日期格式错误，请设置一个范围，如：[ 2023-06-02,2023-06-05 ], error=" + data);
            }
            startTime = DateUtils.toLongDateTime(timeArray[0]);
            if(timeArray.length == 2){
                endTime = DateUtils.toLongDateTime(timeArray[1]) + 235959;
            }
        }
        return new TimeRange(startTime, endTime);
    }

    private static final long getCurrentDateTimeStart(){
        long currentDate = DateUtils.getDateNumber(System.currentTimeMillis());
        return currentDate * 1000000;
    }
}
