package com.walker.infrastructure.tree;

import java.util.ArrayList;
import java.util.List;

public class TreeNode implements Comparable<TreeNode> {

    private long id;
    private String label;
    private long parentId = 0;
    private List<TreeNode> children = null;
    private Object source = null;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    // 2023-07-13
    private String code;

    public TreeNode(long id, String label, List<TreeNode> children, long parentId){
        this.id = id;
        this.label = label;
        this.children = children;
        this.parentId = parentId;
    }
    public TreeNode(long id, String label, List<TreeNode> children, long parentId, String code){
        this.id = id;
        this.label = label;
        this.children = children;
        this.parentId = parentId;
        this.code = code;
    }

    public void addChild(TreeNode node) {
        if(node != null){
            if(children == null){
                this.children = new ArrayList<>(8);
            }
            if(!this.children.contains(node)){
                this.children.add(node);
            }
        }
    }

    public Object getSource() {
        return source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public long getParentId() {
        return parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public List<TreeNode> getChildren() {
        return children;
    }

    public void setChildren(List<TreeNode> children) {
        this.children = children;
    }

    public void cloneProperties(TreeNode node) {
        this.id = node.getId();
        this.label = node.getLabel();
        this.source = node.getSource();
//        this.order = node.getOrder();
    }

    @Override
    public int hashCode(){
        return (int)this.id;
    }

    @Override
    public boolean equals(Object obj){
        if(obj == null){
            return false;
        }
        if(obj instanceof TreeNode){
            TreeNode treeNode = (TreeNode) obj;
            if(treeNode.id == this.id){
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString(){
        return new StringBuilder("[id=").append(this.id)
                .append(", label=").append(this.label)
                .append(", children=").append(this.children)
                .append(", parentId=").append(this.parentId)
                .append("]").toString();
    }

    @Override
    public int compareTo(TreeNode o) {
        return 0;
    }
}
