package com.walker.infrastructure.tree;

import java.util.ArrayList;
import java.util.List;

/**
 * ID采用字符串形式。
 * @author 时克英
 * @date 2023-07-13
 */
public class TreeNodeString implements Comparable<TreeNodeString> {

    private String id;
    private String label;
    private String parentId;
    private List<TreeNodeString> children = null;
    private Object source = null;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    private String code;

    public TreeNodeString(String id, String label, List<TreeNodeString> children, String parentId){
        this.id = id;
        this.label = label;
        this.children = children;
        this.parentId = parentId;
    }
    public TreeNodeString(String id, String label, List<TreeNodeString> children, String parentId, String code){
        this.id = id;
        this.label = label;
        this.children = children;
        this.parentId = parentId;
        this.code = code;
    }

    public void addChild(TreeNodeString node) {
        if(node != null){
            if(children == null){
                this.children = new ArrayList<>(8);
            }
            if(!this.children.contains(node)){
                this.children.add(node);
            }
        }
    }

    public Object getSource() {
        return source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public List<TreeNodeString> getChildren() {
        return children;
    }

    public void setChildren(List<TreeNodeString> children) {
        this.children = children;
    }

    public void cloneProperties(TreeNodeString node) {
        this.id = node.getId();
        this.label = node.getLabel();
        this.source = node.getSource();
//        this.order = node.getOrder();
    }

    @Override
    public int hashCode(){
        return this.id.hashCode();
    }

    @Override
    public boolean equals(Object obj){
        if(obj == null){
            return false;
        }
        if(obj instanceof TreeNodeString){
            TreeNodeString treeNode = (TreeNodeString) obj;
            if(treeNode.id == this.id){
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString(){
        return new StringBuilder("[id=").append(this.id)
                .append(", label=").append(this.label)
                .append(", children=").append(this.children)
                .append(", parentId=").append(this.parentId)
                .append("]").toString();
    }

    @Override
    public int compareTo(TreeNodeString o) {
        return 0;
    }
}
