package com.walker.infrastructure.utils;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

/**
 * 类名称：长整形日期类 类描述：组合Calender，封装Calender的数字接口和方法
 * 
 * 编 写 人： 编写日期：2002年11月16日10时52分
 * 
 * 
 * 修 改 人：祝捷 修改日期：2002年11月29日20时50分 修改内容：由于取得的月份是从00月到11月，所以在取得的当前月份再加一 才是实际的月份
 * 
 * 修 改 人：祝捷 修改日期：2002年12月14日16时50分 修改内容：在函数getLongTime中把时间转换为24小时制,
 */
public class LongCalendar {
	
	private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
	private static final SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy/MM/dd");
	
    /**
     * 返回格式例如：20070728
     * 名称：获得当前长整形日期方法 功能：获得系统中使用长整形表示的日期 输入参数： 返回参数：long:表示的日期长整形值
     */
    public static long getLongCalendar() {
        try {
            long longCalendar = 0;

            // 获得当前日期
            Calendar cldCurrent = Calendar.getInstance();

            // 获得年月日
            String strYear = String.valueOf(cldCurrent.get(Calendar.YEAR));
            String strMonth = String.valueOf(cldCurrent.get(Calendar.MONTH));
            String strDate = String.valueOf(cldCurrent.get(Calendar.DATE));

            // 整理格式
            if (strMonth.length() < 2) {
                strMonth = "0" + strMonth;
            }
            if (strDate.length() < 2) {
                strDate = "0" + strDate;
            }

            // 组合结果
            longCalendar = Long.parseLong(strYear + strMonth + strDate);

            // 系统默认月份加一
            longCalendar += 100L;

            // 创建上初始化上下文环境并返回
            return longCalendar;
        } catch (Exception Exp) {
            return 0;
        }
    }

    /**
     * 把数值转换成带格式的日期，默认为"/"
     * @param canlendar
     * @return
     */
    public static String toString(long canlendar) {
        return LongCalendar.toString(canlendar, "/");
    }
    
    public static String toString(long canlendar, String separator) {
        try {
            if (canlendar == 0) {
                return "";
            }
            StringBuffer sbCalendar = new StringBuffer();

            sbCalendar.insert(0, canlendar);

            // 整理格式
            if (sbCalendar.length() == 8) {
                sbCalendar.insert(6, separator);
                sbCalendar.insert(4, separator);
            } else if (sbCalendar.length() == 14) {
                sbCalendar.insert(12, ":");
                sbCalendar.insert(10, ":");
                sbCalendar.insert(8, " ");
                sbCalendar.insert(6, separator);
                sbCalendar.insert(4, separator);
            } else {
                // 错误处理
                return "";
            }

            // 返回格式化好的整形日期的字符串格式
            return sbCalendar.toString();
        } catch (Exception Exp) {
            // 错误处理
            return "";
        }
    }

    /**
     * 类名称：长整形时间类 类描述：组合Calender，封装Calender的数字接口和方法
     * 
     * 编 写 人：张显达 编写日期：2002年12月12日20时52分
     * 
     */
    public static long getLongTime() {
        try {
            long longCalendar = 0;

            // 获得当前日期
            Calendar cldCurrent = Calendar.getInstance();

            // 获得年月日
            String strYear = String.valueOf(cldCurrent.get(Calendar.YEAR));
            String strMonth = String
                    .valueOf(cldCurrent.get(Calendar.MONTH) + 1);
            String strDate = String.valueOf(cldCurrent.get(Calendar.DATE));
            String strHour = String.valueOf(cldCurrent.get(Calendar.HOUR));
            String strAM_PM = String.valueOf(cldCurrent.get(Calendar.AM_PM));
            String strMinute = String.valueOf(cldCurrent.get(Calendar.MINUTE));
            String strSecond = String.valueOf(cldCurrent.get(Calendar.SECOND));

            // 把时间转换为24小时制
            // strAM_PM=="1",表示当前时间是下午，所以strHour需要加12
            if (strAM_PM.equals("1")) {
                strHour = String.valueOf(Long.parseLong(strHour) + 12);
            }

            // 整理格式
            if (strMonth.length() < 2) {
                strMonth = "0" + strMonth;
            }
            if (strDate.length() < 2) {
                strDate = "0" + strDate;
            }
            if (strHour.length() < 2) {
                strHour = "0" + strHour;
            }
            if (strMinute.length() < 2) {
                strMinute = "0" + strMinute;
            }
            if (strSecond.length() < 2) {
                strSecond = "0" + strSecond;
            }
            // 组合结果
            longCalendar = Long.parseLong(strYear + strMonth + strDate
                    + strHour + strMinute + strSecond);

            // 创建上初始化上下文环境并返回
            return longCalendar;
        } catch (Exception Exp) {
            return 0;
        }
    }

    /**
     * 类名称：由长整型时间变为字符 类描述：通过长整数变为时间格式,可以自动适应8位或16位(格式：2002年12月13日10时25分)
     * 
     * 编 写 人： 编写日期：2002年12月13日10时25分
     * 
     */
    public static String getDateStringByLongDatetime(long longCalendar) {
        try {
            String StrCalendar = String.valueOf(longCalendar);
            String StrCalendarResult = "";
            // 判断为日期型
            if (StrCalendar.length() == 8) {
                StrCalendarResult = StrCalendar.substring(0, 4) + "年"
                        + StrCalendar.substring(4, 6) + "月"
                        + StrCalendar.substring(6, 8) + "日";
                return StrCalendarResult;
            }
            // 判断为日期及时间型
            if (StrCalendar.length() == 14) {
                StrCalendarResult = StrCalendar.substring(0, 4) + "年"
                        + StrCalendar.substring(4, 6) + "月"
                        + StrCalendar.substring(6, 8) + "日";
                StrCalendarResult = StrCalendarResult + " "
                        + StrCalendar.substring(8, 10) + ":"
                        + StrCalendar.substring(10, 12) + ":"
                        + StrCalendar.substring(12, 14);
                return StrCalendarResult;
            }
            // 否则返回空字符
            return "";
        } catch (Exception e) {
            // 错误处理
            e.printStackTrace();
            return "";
        }
    }

    public static String getDateStringByLongDatetimeForPage(long longCalendar) {
        try {
            String StrCalendar = String.valueOf(longCalendar);
            String StrCalendarResult = "";
            // 判断为日期型
            if (StrCalendar.length() == 8) {
                StrCalendarResult = StrCalendar.substring(0, 4) + "/"
                        + StrCalendar.substring(4, 6) + "/"
                        + StrCalendar.substring(6, 8);
                return StrCalendarResult;
            }
            // 判断为日期及时间型
            if (StrCalendar.length() == 14) {
                StrCalendarResult = StrCalendar.substring(0, 4) + "/"
                        + StrCalendar.substring(4, 6) + "/"
                        + StrCalendar.substring(6, 8);
                StrCalendarResult = StrCalendarResult + " "
                        + StrCalendar.substring(8, 10) + ":"
                        + StrCalendar.substring(10, 12);
                return StrCalendarResult;
            }
            // 否则返回空字符
            return "";
        } catch (Exception e) {
            // 错误处理
            e.printStackTrace();
            return "";
        }
    }

    /**
     * 编写人：刘琨 名称：getCurrentDate 功能：得到系统当前时间 输入参数： 返回参数：String:系统当前时间
     */
    public static String getCurrentDate() {
        return getDateStringByLongDatetimeForPage(getLongCalendar());
    }

    /**
     * 
     * @说明：由日期的字符串形式得到八位数的长整形数字格式. 功能：由日期的字符串形式得到八位数的长整形数字格式.
     * @author 李彬
     * @date 2007-4-14
     * @param strCalender
     * @param strFGF
     * @return
     */
    public static long longCalender(String strCalender, String strFGF) {
        long longCal = 0;
        try {
            if (!(strCalender == null || strCalender.equals(""))) {

                String[] calendars = strCalender.split(strFGF);
                if (calendars.length == 3) {
                    String strYear = calendars[0];
                    String strMon = calendars[1];
                    String strDay = calendars[2];
                    if (strMon.length() == 1) {
                        strMon = "0" + strMon;
                    }
                    if (strDay.length() == 1) {
                        strDay = "0" + strDay;
                    }
                    longCal = Long.parseLong(strYear + strMon + strDay);
                }
            } else {
                return 0;
            }
        } catch (Exception ex) {
            return 0;
        }
        return longCal;
    }

    /**
     * @说明：由日期的字符串形式得到14位数的长整形数字格式. 
     * 功能：由日期的字符串形式得到八位数的长整形数字格式：2012-07-13 00:00:00 to 20070414000000.
     * @author 高冬冬
     * @date 2012-07-13 
     * @param strCalender 日历字符串
     * @return
     */
    public static long toLongCalendar(String strCalender, String strFGF){
        long longCal = 0;
        try {
            if (!(strCalender == null || strCalender.equals(""))) {

                strCalender = strCalender.replace(" ", "").replace(":", "");
                String[] calendars = strCalender.split(strFGF);
                if (calendars.length == 3) {
                    String strYear = calendars[0];
                    String strMon = calendars[1];
                    String strDay = calendars[2];
                    if (strMon.length() == 1) {
                        strMon = "0" + strMon;
                    }
                    if (strDay.length() == 7) {
                        strDay = "0" + strDay;
                    }
                    longCal = Long.parseLong(strYear + strMon + strDay);
                }
            } else {
                return 0;
            }
        } catch (Exception ex) {
            return 0;
        }
        return longCal;
    }
    /**
     * 编写人：张显达 名称：getCurrentDateView 功能：得到系统当前时间显示，格式：yyyy/mm/dd主要是为页面显示用 输入参数：
     * 返回参数：String:系统当前时间
     */
    public static String getCurrentDateView() {
        // 获得当前日期
        Calendar cldCurrent = Calendar.getInstance();
        // 获得年月日
        String strYear = String.valueOf(cldCurrent.get(Calendar.YEAR));
        String strMonth = String.valueOf(cldCurrent.get(Calendar.MONTH) + 1);
        String strDate = String.valueOf(cldCurrent.get(Calendar.DATE));
        // 整理格式
        if (strMonth.length() < 2) {
            strMonth = "0" + strMonth;
        }
        if (strDate.length() < 2) {
            strDate = "0" + strDate;
        }
        // 得出当天日期的字符串
        String StrCurrentCalendar = strYear + "/" + strMonth + "/" + strDate;
        return StrCurrentCalendar;
    }
    
    private static final String FILE_SEPARATOR = "/";
    
    /**
     * 返回当前年月路径字符串，如：2014/3/
     * @return
     */
    public static final String getCurrentMonth(){
    	Calendar cldCurrent = Calendar.getInstance();
    	return new StringBuilder().append(cldCurrent.get(Calendar.YEAR))
    			.append(FILE_SEPARATOR)
    			.append((cldCurrent.get(Calendar.MONTH) + 1))
    			.append(FILE_SEPARATOR).toString();
    }

    /**
     * 编写人：张显达 名称：getCurrentDateView 功能：得到系统当前时间显示，格式：yyyy/mm/dd主要是为页面显示用
     * 输入参数：long longCalendar 返回参数：String:系统当前时间
     */
    public static String getCurrentDateView(long longCalendar) {
        if (longCalendar == 0) {
            return "";
        }
        String strDateView = String.valueOf(longCalendar);
        // 获得年月日
        String strYear = strDateView.substring(0, 4);
        String strMonth = strDateView.substring(4, 6);
        String strDate = strDateView.substring(6, 8);
        // 整理格式
        if (strMonth.length() < 2) {
            strMonth = "0" + strMonth;
        }
        if (strDate.length() < 2) {
            strDate = "0" + strDate;
        }
        // 得出当天日期的字符串
        String StrCurrentCalendar = strYear + "/" + strMonth + "/" + strDate;
        return StrCurrentCalendar;
    }

    /**
     * 类名称：addMonth 类描述：通过参数日期及要加得月份得到一端时间后得时间
     * 
     * 编 写 人： 编写日期：2002年11月16日10时52分
     * 
     * 修 改 人： 修改日期： 修改内容：
     * 
     * 版本：
     * 
     * 目前不是很完善，需要进行修改
     * 
     */
    public static long addMonth(long calendar, int month) {
        try {
            long longDate = 0;

            if (!checkCalendar(calendar)) {
                return -1;
            }

            int intYear = Integer.parseInt(String.valueOf(calendar).substring(
                    0, 4));
            int intMonth = Integer.parseInt(String.valueOf(calendar).substring(
                    4, 6)) - 1;
            int intDate = Integer.parseInt(String.valueOf(calendar)
                    .substring(6));

            GregorianCalendar gCalendar = new GregorianCalendar(intYear,
                    intMonth, intDate);

            gCalendar.add(GregorianCalendar.MONTH, month);

            longDate = gCalendar.get(GregorianCalendar.YEAR) * 10000L
                    + (gCalendar.get(GregorianCalendar.MONTH) + 1) * 100L
                    + gCalendar.get(GregorianCalendar.DATE);

            return longDate;
        } catch (Exception Exp) {
            return -1;
        }
    }

    // 目前不是很完善，需要进行修改
    public static boolean checkCalendar(long calendar) {
        try {

            return true;
        } catch (Exception Exp) {
            return false;
        }
    }

    /**
     * 类名称：由长整型时间变为字符 类描述：通过长整数变为时间格式,输入参数为6位的时间
     * 
     * 编 写 人：左靖宇 编写日期：2003年3月6日
     * 
     */
    public static String getTimeStringByLongTime(long longCalendar) {
        return getTimeStringByLongTime(longCalendar, true);
    }

    public static String getTimeStringByLongTime(long longCalendar, boolean formatCn) {
        try {
            String StrCalendar = String.valueOf(longCalendar);
//            String StrCalendarResult = "";

            // 判断为时间型
            if (StrCalendar.length() == 6) {
            	StringBuilder s = new StringBuilder(StrCalendar.substring(0, 2));
            	if(formatCn)
            		s.append("时");
            	else
            		s.append(":");
            	s.append(StrCalendar.substring(2, 4));
            	if(formatCn)
            		s.append("分");
            	else
            		s.append(":");
            	s.append(StrCalendar.substring(4, 6));
            	if(formatCn)
            		s.append("秒");
//                StrCalendarResult = StrCalendar.substring(0, 2) + ":"
//                        + StrCalendar.substring(2, 4) + ":"
//                        + StrCalendar.substring(4, 6);
                return s.toString();
            } else
            	throw new RuntimeException("请输入6位数的日期");
        } catch (Exception e) {
            // 错误处理
            e.printStackTrace();
            throw new RuntimeException("转换日期格式错误: " + e.getMessage());
        }
    }

    /**
     * 类名称：月份增加 类描述：月份增加
     * 
     * 编 写 人：左靖宇 编写日期：
     * 
     */
    public static long getCalendarByMonthAdd(long longCalendar, int num) {
        try {
//            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            Date date = sdf.parse(Long.toString(longCalendar),
                    new ParsePosition(0));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(Calendar.MONTH, num);
            return Long.parseLong(sdf.format(calendar.getTime()));
        } catch (Exception e) {
            return -1;
        }
    }
    /**
     * 年份增加
     * 编 写 人：彭业建
     * 
     * 
     */
    public static long getCalendarByYearAdd(long longCalendar, int num){
    	 try {
//             SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
             Date date = sdf.parse(Long.toString(longCalendar));
             Calendar calendar = Calendar.getInstance();
             calendar.setTime(date);
             calendar.add(Calendar.YEAR, num);
             return Long.parseLong(sdf.format(calendar.getTime()));
         } catch (Exception e) {
             return -1;
         }
    }
    /**
     * 类名称：类描述：得到当前日期的格式化显示
     * 
     * 编 写 人：彭业建 编写日期： 返回参数 : yyyy年MM月dd日
     */
    public static String getCurrentDateForpage(){
     return getDateStringByLongDatetime(getLongCalendar());
    	
    }
  
    /**
     * 类名称：getCalendarAfterDays 类描述：获得当前日期增加N天(可正可负)后的日期
     * 
     * 编 写 人：刘国军 编写日期： 返回参数 : yyyy/MM/dd
     */
    public static String getCalendarAfterDays(int daysNumber) {
        // 定义日期格式i
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        Calendar now = Calendar.getInstance();
        now.add(Calendar.DATE, daysNumber);

        return sdf2.format(now.getTime());
    }

    /**
     * 
     * 说明：获得给定日期增加N天(可正可负)后的日期 作者：时克英 时间：2007-4-27
     */
    public static String getCalendarAfterDays(long longDate, int daysNumber) {
        Calendar calendar = Calendar.getInstance();
        String strDate = String.valueOf(longDate);
        int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(4, 6)) - 1;
        int day = Integer.parseInt(strDate.substring(6, 8));
        calendar.set(year, month, day);
        calendar.add(Calendar.DATE, daysNumber);

//        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        return sdf2.format(calendar.getTime());
    }

    public static Date toDate(long longDate) {
        Calendar calendar = Calendar.getInstance();
        String strDate = String.valueOf(longDate);
        int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(4, 6)) - 1;
        int day = Integer.parseInt(strDate.substring(6, 8));
        calendar.set(year, month, day);
        return calendar.getTime();
    }

    public static Date toDateTime(long longDate) {
        Calendar calendar = Calendar.getInstance();
        String strDate = String.valueOf(longDate);
        int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(4, 6)) - 1;
        int day = Integer.parseInt(strDate.substring(6, 8));
        int hour = Integer.parseInt(strDate.substring(8, 10));
        int minute = Integer.parseInt(strDate.substring(10, 12));
        int second = Integer.parseInt(strDate.substring(12, 14));
        calendar.set(year, month, day, hour, minute, second);
        return calendar.getTime();
    }

    public static String toTimeLineTime(long longDate) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("MMM dd yyyy",
                Locale.ENGLISH);
        SimpleDateFormat sdfTime = new SimpleDateFormat("MMM dd yyyy HH:mm:ss",
                Locale.ENGLISH);
        String formatData;
        if (String.valueOf(longDate).length() > 8) {
            formatData = sdfTime.format(toDateTime(longDate));
        } else {
            formatData = sdfDate.format(toDate(longDate));
        }
        
        return formatData;
    }
    
    public static String toTimeLineTime(String strDate) {
        long longDate = Long.parseLong(strDate);
        SimpleDateFormat sdfDate = new SimpleDateFormat("MMM dd yyyy",
                Locale.ENGLISH);
        SimpleDateFormat sdfTime = new SimpleDateFormat("MMM dd yyyy HH:mm:ss",
                Locale.ENGLISH);
        String formatData;
        if (String.valueOf(longDate).length() > 8) {
            formatData = sdfTime.format(toDateTime(longDate));
        } else {
            formatData = sdfDate.format(toDate(longDate));
        }
        
        return formatData;
    }

    public static final String[] weekDefine = new String[] { "周日", "周一", "周二", "周三", "周四", "周五","周六" };
    
    public static String toDayOfWeek(long longDate) {
//        String[] dayOfWeek = new String[] { "周日", "周一", "周二", "周三", "周四", "周五",
//                "周六" };
        Calendar calendar = Calendar.getInstance();
        String strDate = String.valueOf(longDate);
        int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(4, 6)) - 1;
        int day = Integer.parseInt(strDate.substring(6, 8));
        calendar.set(year, month, day);
        int index = calendar.get(Calendar.DAY_OF_WEEK) - 1;
        return weekDefine[index];
    }

    /**
     * 
     * 说明：返回当前日期是本周第几天 作者：时克英 时间：2007-4-23
     */
    public static int whichDayOfWeek(long longDate) {
        Calendar calendar = Calendar.getInstance();
        String strDate = String.valueOf(longDate);
        int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(4, 6)) - 1;
        int day = Integer.parseInt(strDate.substring(6, 8));
        calendar.set(year, month, day);
        int whichDay = calendar.get(Calendar.DAY_OF_WEEK);
        if (whichDay == 1) {
            return 7;
        } else {
            return whichDay - 1;
        }
    }
    /**
     * 类名称：类描述：计算两个日期相差的天数，begin,end格式yyyMMdd
     * 
     * 编 写 人：彭业建 编写日期： 
     */
    public static long getDays(String begin, String end){
    	try{
//		SimpleDateFormat sdf = new java.text.SimpleDateFormat("yyyyMMdd");
		Date begin1 = sdf.parse(begin);
		Date end1 = sdf.parse(end);
		return (end1.getTime() - begin1.getTime()) / (24 * 60 * 60 * 1000);
    	}catch(Exception ex){
    		return 0;
    	}
	}
    /**
     * 类名称：类描述：计算日期加上或减去某个数后的日期
     * 编 写 人：彭业建 编写日期
     * @param date 要计算的日期
     * @param amount，加或减的天数
     * @return 计算后的日期
     */
    public static long getDateAfterAddDateNum(long date,int amount){
		try{
//			SimpleDateFormat sdf = new java.text.SimpleDateFormat("yyyyMMdd");
			Date begin= sdf.parse(String.valueOf(date));
			Calendar currentDate=Calendar.getInstance();
			currentDate.setTime(begin);
			currentDate.add(Calendar.DAY_OF_MONTH 
					, amount);
			String dateStr=sdf.format(currentDate.getTime());
			return Long.parseLong(dateStr);
			
	    }catch(Exception ex){
	    		return 0;
	   }
		
	}
   
    /**
	 * 根据输入的日期，返回所在周的第一天日期
	 * @param _cntDate
	 * @return
	 */
	public static long getFirstDayOfWeek(long _cntDate){
		int whichDay = LongCalendar.whichDayOfWeek(_cntDate);
		return LongCalendar.getDateAfterAddDateNum(_cntDate, - whichDay + 1);
	}
	
	/**
	 * 返回本周最后一天
	 * @param _firstDate:本周第一天
	 * @return
	 */
	public static long getLastDayOfWeek(long _firstDate){
		return LongCalendar.getDateAfterAddDateNum(_firstDate, 6);
	}
	
	protected static boolean isLeapYear(int year) {
        return ((year % 4 == 0 && year % 100 != 0) || (year % 400 == 0));
    }

    public static int getLastDayOfMonth(int monthNum, int year) {

        switch (monthNum) {
            case 1:
                return 31;
            case 2:
                return (isLeapYear(year)) ? 29 : 28;
            case 3:
                return 31;
            case 4:
                return 30;
            case 5:
                return 31;
            case 6:
                return 30;
            case 7:
                return 31;
            case 8:
                return 31;
            case 9:
                return 30;
            case 10:
                return 31;
            case 11:
                return 30;
            case 12:
                return 31;
            default:
                throw new IllegalArgumentException("Illegal month number: "
                        + monthNum);
        }
    }
	
    public static void main(String[] args) {
    	/*System.out.println(getLongCalendar());
    	System.out.println(LongCalendar.getLongTime());*/
    	//long s=20070809L;
    	//System.out.println(LongCalendar.getDateStringByLongDatetime(s));
        String s= "2012/07/13 09:11:33";
        System.out.println(LongCalendar.toLongCalendar(s, "/"));
        System.out.println(getTimeStringByLongTime(130529));
    }
}