package com.walker.infrastructure.utils;

import java.text.DecimalFormat;

public class MoneyUtils {

    /**
     * 把金额（分）转成元，并强制保留2位小数。如：120 --> 1.20
     * @param fen
     * @return
     * @date 2023-20-29
     */
    public static final String scaleYuan2Accuracy(long fen){
        double yuan = fen / 100.0;
        DecimalFormat df2 = new DecimalFormat("#.##");
        String score = df2.format(yuan);
//        System.out.println("score = " + score);
        if(score.indexOf(StringUtils.SYMBOL_DOT) < 0){
            // 只有元，没有小数，需要加上
            return score + ".00";
        }
        // 存在小数，如果只有一位需要补充0
        String decimal = score.substring(score.indexOf(StringUtils.SYMBOL_DOT) + 1);
        if(decimal.length() == 2){
            return score;
        } else if(decimal.length() == 1){
            return score + "0";
        } else {
            throw new UnsupportedOperationException("没有小数，金额转换错误：" + score);
        }
    }
}
