package com.walker.infrastructure.utils;

import java.text.DecimalFormat;

/**
 * 数值格式工具类。
 * @author 时克英
 * @date 2022-09-26
 */
public class NumberFormatUtils {

//    private static final DecimalFormat df2 = new DecimalFormat("#.00");
//    private static final DecimalFormat df2 = new DecimalFormat("#.##");

    /**
     * 把精度小数，按四舍五入方式，转成整数。
     * @param value
     * @return
     * @date 2023-07-08
     */
    public static final double scaleRoundToInt(double value){
        if(value <= 0){
            return value;
        }
        return new Double(Math.round(value)).intValue();
    }

    /**
     * 给定数值保留2位小数。
     * @param value
     * @return
     */
    public static final double scaleAccuracy2(double value){
        DecimalFormat df2 = new DecimalFormat("#.00");
        String score = df2.format(value);
        return Double.parseDouble(score);
    }
}
