package com.walker.infrastructure.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PhoneNumberUtils {

    /**
     * 手机号脱敏处理
     * @param phone 手机号
     * @date 2023-05-17
     */
    public static String maskMobile(String phone) {
        if (StringUtils.isEmpty(phone)) {
            return StringUtils.EMPTY_STRING;
        }
        return phone.replaceAll(REGEX_MOBILE_MASK, REGEX_MOBILE_REPLACE);
    }

    /**
     * 判断给定号码是否为固定号码
     * @param number 固定电话号码
     * @return
     */
    public static final boolean isFixedPhoneNumber(String number){
        Matcher match = PATTERN_FIXEDPHONE.matcher(number);
        return match.matches();
    }

    /**
     * 判断是否为手机号码
     * @param number
     * @return
     */
    public static final boolean isCellPhoneNumber(String number){
        Matcher match = PATTERN_MOBILEPHONE.matcher(number);
        return match.matches();
    }

    /**
     * 获取固定号码号码中的区号
     *
     * @param strNumber
     * @return
     */
    public static final String getZipFromHomephone(String strNumber) {
        Matcher matcher = PATTERN_ZIPCODE.matcher(strNumber);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static final String REGEX_MOBILE_REPLACE = "$1****$2";
    public static final String REGEX_MOBILE_MASK = "(\\d{3})\\d{4}(\\d{4})";
    //用于匹配手机号码
    public final static String REGEX_MOBILEPHONE = "^0?1[3456789]\\d{9}$";

    //用于匹配固定电话号码
    public final static String REGEX_FIXEDPHONE = "^(010|02\\d|0[3-9]\\d{2})?\\d{6,8}$";

    //用于获取固定电话中的区号
    public final static String REGEX_ZIPCODE = "^(010|02\\d|0[3-9]\\d{2})\\d{6,8}$";

    private static final Pattern PATTERN_FIXEDPHONE = Pattern.compile(REGEX_FIXEDPHONE);

    private static final Pattern PATTERN_MOBILEPHONE = Pattern.compile(REGEX_MOBILEPHONE);

    private static final Pattern PATTERN_ZIPCODE = Pattern.compile(REGEX_ZIPCODE);
}
