package com.walker.infrastructure.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;

public class UrlUtils {

    /**
     * 转码前端通过URL提交的参数。
     * @param url
     * @return
     * @date 2023-05-17
     */
    public static String decode(String url) {
        return decode(url, StringUtils.DEFAULT_CHARSET_UTF8);
    }

    public static String decode(String content, Charset charset) {
        if (null == charset) {
            charset = defaultCharset();
        }
        return decode(content, charset.name());
    }

    public static Charset defaultCharset() {
        return Charset.defaultCharset();
    }

    public static final String decode(String url, String charset){
        if(StringUtils.isEmpty(url)){
            return url;
        }
        try {
            return URLDecoder.decode(url, charset);
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("decode错误，字符集不支持：" + charset, e);
        }
    }
}
