package com.walker.location;

public class DistanceUtils {

//	private static final double EARTH_RADIUS = 6378.137;
//	private static double rad(double d){
//	    return d * Math.PI / 180.0;
//	}
//	public static double getDistance(double lat1, double lng1, double lat2, double lng2){
//	    double radLat1 = rad(lat1);
//	    double radLat2 = rad(lat2);
//	    double a = radLat1 - radLat2;
//	    double b = rad(lng1) - rad(lng2);
//	    double s = 2 * Math.asin(Math.sqrt(Math.pow(Math.sin(a/2),2) +
//	     Math.cos(radLat1)*Math.cos(radLat2)*Math.pow(Math.sin(b/2),2)));
//	    s = s * EARTH_RADIUS;
//	    return Math.round(s * 10000) / 10000;
//	}

	private final static double PI = 3.14159265358979323; // 圆周率
    private final static double R = 6371229; // 地球的半径

	/**
	 * 返回两个坐标的球面距离。
	 * @param longt1
	 * @param lat1
	 * @param longt2
	 * @param lat2
	 * @return
	 * @date 2017-10-12
	 */
    public static final double getDistance(double longt1, double lat1, double longt2, double lat2) {
        double x, y;
        x = (longt2 - longt1) * PI * R
                * Math.cos(((lat1 + lat2) / 2) * PI / 180) / 180;
        y = (lat2 - lat1) * PI * R / 180;
        return Math.hypot(x, y);
    }

    /**
     * 返回两点之间的平面距离，通过三角函数计算。
     * @param longt1
     * @param lat1
     * @param longt2
     * @param lat2
     * @return
     */
    public static final double getFlatDistance(double longt1, double lat1, double longt2,double lat2){
    	double _x = Math.abs(longt1 - longt2);
		double _y = Math.abs(lat1 - lat2);
		return Math.sqrt(_x*_x+_y*_y);
    }

	public static void main(String[] args){
		double destLon = 121.541924;
		double destLat = 31.272223;
		System.out.println("d1 = " + getDistance(121.537369, 31.278162, destLon,destLat));
		System.out.println("平面距离 d1 = " + getFlatDistance(121.537369, 31.278162, destLon,destLat));

		long startTime = System.nanoTime();
		System.out.println("d2 = " + getDistance(121.557634, 31.312228,  destLon,destLat));
		System.out.println("d2 花费时间：" + (System.nanoTime()-startTime));

		startTime = System.nanoTime();
		System.out.println("平面距离 d2 = " + getFlatDistance(121.557634, 31.312228,  destLon,destLat));
		System.out.println("d2平面 花费时间：" + (System.nanoTime()-startTime));

		startTime = System.nanoTime();
		System.out.println("d3 = " + getDistance(121.557634, 31.312228, 121.537369,31.278162));
		System.out.println("d3平面 花费时间：" + (System.nanoTime()-startTime));
		System.out.println("平面距离 d3 = " + getFlatDistance(121.557634, 31.312228, 121.537369,31.278162));
	}
}
