package com.walker.push;

import java.io.Serializable;
import java.util.List;

/**
 * 通知消息对象定义。
 * @author 时克英
 * @date 2023-04-21
 */
public class Notification implements Serializable {

    @Override
    public String toString(){
        return new StringBuilder("[id=").append(this.id)
                .append(", from=").append(this.from)
                .append(", title=").append(this.title)
                .append(", content=").append(this.content)
                .append(", receiverList=").append(this.receiverList)
                .append(", channelList=").append(this.channelList)
                .append(", delayedTime=").append(this.delayedTime)
                .append("]").toString();
    }

    /**
     * 推送消息唯一编号。
     * @return
     */
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    /**
     * 创建时间，系统时间格式
     * @return
     */
    public long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    /**
     * 消息创建者唯一标识，一般为用户ID
     * @return
     */
    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    /**
     * 推送标题
     * @return
     */
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * 推送内容
     * @return
     */
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    /**
     * 推送人，通常为发布者信息，如：发送手机号、发送的公众号主体名称
     * @return
     */
    public String getFrom() {
        return from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    /**
     * 返回推送对象集合，一般是用户标识，由推送实现自己确定。
     * @return
     */
    public List<String> getReceiverList() {
        return receiverList;
    }

    public void setReceiverList(List<String> receiverList) {
        this.receiverList = receiverList;
    }

    /**
     * 返回推送通道集合，支持同时多个通道发送，如：短信 + 公众号
     * @return
     */
    public List<NotificationChannel> getChannelList() {
        return channelList;
    }

    public void setChannelList(List<NotificationChannel> channelList) {
        this.channelList = channelList;
    }

    /**
     * 返回推送时间类型，参见：{@linkplain TimeType}
     * @return
     */
    public TimeType getTimeType() {
        return timeType;
    }

    public void setTimeType(TimeType timeType) {
        this.timeType = timeType;
    }

    /**
     * 当时间类型为：Delayed时，设置延时推送的时间，格式：20230421161500
     * @return
     */
    public long getDelayedTime() {
        return delayedTime;
    }

    public void setDelayedTime(long delayedTime) {
        this.delayedTime = delayedTime;
    }

    /**
     * 返回业务传入的额外数据，标识一个业务类型，如：公文流程待办通知等。
     * @return
     */
    public String getOptionType() {
        return optionType;
    }

    public void setOptionType(String optionType) {
        this.optionType = optionType;
    }

    /**
     * 是否广播推送，对于广播方式对所有平台用户，无需设置具体接收人。
     * <p>而且广播推送，不会调用策略。</p>
     * @return
     */
    public boolean getBroadcast() {
        return broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    /**
     * 推送消息是否支持持久化保存（到数据库）
     * @return
     */
    public boolean getPersistent() {
        return persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    /**
     * 消息对应的业务ID，由业务自己确定是否使用。
     * @return
     */
    public String getOptionId() {
        return optionId;
    }

    public void setOptionId(String optionId) {
        this.optionId = optionId;
    }

    /**
     * 多个通道时，是否并行同时发送，true：并行，false：串行
     * @return
     * @date 2023-04-26
     */
    public boolean getParallel() {
        return parallel;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    // 多个通道时，是否并行同时发送
    private boolean parallel = false;
    private boolean persistent = true;
    private boolean broadcast = false;
    private String id;
    private long createTime;
    private String creator;
    private String title;
    private String content;
    private String from;
    private List<String> receiverList;
    private List<NotificationChannel> channelList;
    private TimeType timeType = TimeType.None;
    private long delayedTime = 0;
    private String optionType;
    private String optionId;
}
