package com.walker.push;

/**
 * 推送通道定义。
 * @author 时克英
 * @date 2023-04-21
 */
public enum NotificationChannel {

    Sms {
        public String getIndex(){
            return INDEX_SMS;
        }
        public String getName(){
            return NAME_SMS;
        }
    },
    OfficialAccount {
        public String getIndex(){
            return INDEX_WX;
        }
        public String getName(){
            return NAME_WX;
        }
    },
    Tcp {
        public String getIndex(){
            return INDEX_TCP;
        }
        public String getName(){
            return NAME_TCP;
        }
    },
    WebSocket {
        public String getIndex(){
            return INDEX_WEB_SOCKET;
        }
        public String getName(){
            return NAME_WEB_SOCKET;
        }
    },
    ThirdParty {
        public String getIndex(){
            return INDEX_THIRD_PARTY;
        }
        public String getName(){
            return NAME_THIRD_PARTY;
        }
    },

    Mail {
        public String getIndex(){
            return INDEX_MAIL;
        }
        public String getName(){
            return NAME_MAIL;
        }
    },

    /**
     * 该类型并不推送，需要前端主动查询。
     * @date 2023-04-25
     */
    System {
        public String getIndex(){
            return INDEX_SYSTEM;
        }
        public String getName(){
            return NAME_SYSTEM;
        }
    };

    public String getIndex(){
        throw new AbstractMethodError();
    }
    public String getName(){
        throw new AbstractMethodError();
    }

    public static final NotificationChannel getType(String index){
        if(index.equalsIgnoreCase(INDEX_SMS)){
            return Sms;
        } else if (index.equalsIgnoreCase(INDEX_WX)) {
            return OfficialAccount;
        } else if (index.equalsIgnoreCase(INDEX_TCP)) {
            return Tcp;
        } else if (index.equalsIgnoreCase(INDEX_WEB_SOCKET)) {
            return WebSocket;
        } else if (index.equalsIgnoreCase(INDEX_THIRD_PARTY)) {
            return ThirdParty;
        } else if (index.equalsIgnoreCase(INDEX_SYSTEM)) {
            return System;
        } else {
            throw new UnsupportedOperationException("未支持的推送通道:" + index);
        }
    }

    public static final String INDEX_SMS = "sms";
    public static final String INDEX_WX = "wx";
    public static final String INDEX_TCP = "tcp";
    public static final String INDEX_WEB_SOCKET = "web_socket";
    public static final String INDEX_THIRD_PARTY = "third_party";
    public static final String INDEX_MAIL = "mail";
    public static final String INDEX_SYSTEM = "system";

    public static final String NAME_SMS = "短信";
    public static final String NAME_WX = "公众号";
    public static final String NAME_TCP = "长连接";
    public static final String NAME_WEB_SOCKET = "网页";
    public static final String NAME_THIRD_PARTY = "第三方";
    public static final String NAME_MAIL = "邮件";
    public static final String NAME_SYSTEM = "系统（不推送）";
}
