package com.walker.push;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 推送结果定义，当推送完成时，会返回结果，包含：未成功推送等信息。
 * @author 时克英
 * @date 2023-04-21
 */
public class PushResult implements Serializable {

    @Override
    public String toString(){
        return new StringBuilder("[code=").append(this.code)
                .append(", text=").append(this.text)
                .append(", failedList=").append(this.failedList)
                .append("]").toString();
    }

    public boolean isSuccess(){
        return this.code == 0;
    }

    /**
     * 返回状态码：0 成功，其他值失败
     * @return
     */
    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    /**
     * 返回失败内容描述
     * @return
     */
    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    /**
     * 返回推送失败的用户集合
     * @return
     */
    public List<String> getFailedList() {
        return failedList;
    }

    public void setFailedList(List<String> failedList) {
        this.failedList = failedList;
    }

    /**
     * 添加一个失败推送用户标识。
     * @param receiver
     */
    public void addOneFailed(String receiver){
        if(this.failedList == null){
            this.failedList = new ArrayList<>();
        }
        this.failedList.add(receiver);
    }

    private int code = 0;
    private String text;
    private List<String> failedList;
}
