package com.walker.push;

/**
 * 推送时间类型。
 * @author 时克英
 * @date 2023-04-21
 */
public enum TimeType {

    None {
        public int getIndex(){
            return INDEX_NONE;
        }
    },
    Delayed {
        public int getIndex(){
            return INDEX_DELAYED;
        }
    };

    public int getIndex(){
        throw new AbstractMethodError();
    }

    public static final TimeType getType(int index){
        if(index == INDEX_NONE){
            return None;
        } else if (index == INDEX_DELAYED) {
            return Delayed;
        } else {
            throw new UnsupportedOperationException("不支持的时间类型：" + index);
        }
    }

    public static final int INDEX_NONE = 0;
    public static final int INDEX_DELAYED = 1;

}
