package com.walker.push.support;

import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.PhoneNumberUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.AbstractPushObject;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.SmsMessage;

import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSmsPush extends AbstractPushObject<SmsMessage> {

    @Override
    public NotificationChannel getNotificationChannel() {
        return NotificationChannel.Sms;
    }

    @Override
    public List<SmsMessage> translateToTarget(Notification notification) {
        List<SmsMessage> data = new ArrayList<>(4);
        SmsMessage smsMessage = new SmsMessage();
        String userPhoneNum = null;
        for(String user: notification.getReceiverList()){

            // 这里需要特殊处理，如果传入的就是手机号，无需转换。例如：验证码场景，因为登录时还不知道用户信息。
            // 因此，只能使用手机号。2023-04-25
            if(PhoneNumberUtils.isCellPhoneNumber(user)){
                userPhoneNum = user;
            } else {
                userPhoneNum = this.getUserMobile(user);
            }
            if(StringUtils.isEmpty(userPhoneNum)){
                logger.warn("未查找到用户手机号，user = {}", user);
                continue;
            }
            smsMessage.addMobile(userPhoneNum);
        }

        try {
            SmsMessage message = JsonUtils.jsonStringToObject(notification.getContent(), SmsMessage.class);
            smsMessage.setTemplateId(message.getTemplateId());
            smsMessage.setTemplateParam(message.getTemplateParam());
        } catch (Exception e) {
            throw new RuntimeException("消息内容json转换错误:" + e.getMessage(), e);
        }
        data.add(smsMessage);
        return data;
    }

    /**
     * 获取用户手机号
     * @param userId
     * @return
     */
    protected abstract String getUserMobile(String userId);
}
