package com.walker.push.util;

import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.PushResult;

import java.util.ArrayList;
import java.util.List;

public class PushUtils {

    public static final String FROM_MOBILE = "平台号码";

    /**
     * 返回一个短信发送通知对象。
     * @param title
     * @param content
     * @param targetUser 目标用户id
     * @param creator
     * @return
     * @date 2023-04-24
     */
    public static final Notification acquireSmsNotification(String title, String content
            , String targetUser, String creator){
        List<String> targetMobileList = new ArrayList<>(2);
        targetMobileList.add(targetUser);
        List<NotificationChannel> channels = new ArrayList<>(2);
        channels.add(NotificationChannel.Sms);
        return acquireNotification(title, content, FROM_MOBILE, targetMobileList, creator, true, channels, false);
    }

    public static final Notification acquireSmsNotification(String title, String content
            , List<String> targetList, String creator, boolean persistent){
        List<NotificationChannel> channels = new ArrayList<>(2);
        channels.add(NotificationChannel.Sms);
        return acquireNotification(title, content, FROM_MOBILE, targetList, creator, persistent, channels, false);
    }

    public static final Notification acquireEmailNotificationOne(String title, String content, String from
            , String targetMail, String creator){
        List<String> targetMailList = new ArrayList<>(2);
        targetMailList.add(targetMail);
        return acquireEmailNotification(title, content, from, targetMailList, creator, true);
    }

    public static final Notification acquireEmailNotification(String title, String content, String from
            , List<String> targetMailList, String creator, boolean persistent){
        List<NotificationChannel> channels = new ArrayList<>(2);
        channels.add(NotificationChannel.Mail);
        return acquireNotification(title, content, from, targetMailList, creator, persistent, channels, false);
    }

    /**
     * 创建一个通用发送通知对象。
     * @param title 标题
     * @param content 文本内容
     * @param from 发送原始地址
     * @param targetList 目标地址集合
     * @param creator 创建人id
     * @param persistent 是否保存该消息
     * @return
     * @date 2023-04-23
     */
    public static final Notification acquireNotification(String title, String content, String from
            , List<String> targetList, String creator, boolean persistent
            , List<NotificationChannel> channelList, boolean parallel){
        Notification notification = new Notification();
        notification.setId(NumberGenerator.getLongSequenceId());
        notification.setTitle(title);
        notification.setContent(content);
        notification.setPersistent(persistent);
        notification.setFrom(from);
        notification.setCreateTime(DateUtils.getDateTimeNumber());

//        List<NotificationChannel> channels = new ArrayList<>(2);
//        channels.add(channel);
        notification.setChannelList(channelList);

        notification.setReceiverList(targetList);
        notification.setCreator(creator);
        notification.setParallel(parallel);
        return notification;
    }

    public static final PushResult acquireSuccessPushResult(){
        PushResult pushResult = new PushResult();
        pushResult.setText("success");
        return pushResult;
    }

    /**
     * 获得一个失败推送结果
     * @param msg 描述
     * @param userId 目标用户id
     * @return
     */
    public static final PushResult acquireFailedPushResult(String msg, String userId){
        PushResult pushResult = new PushResult();
        pushResult.setCode(-1);
        pushResult.setText(msg);
        pushResult.addOneFailed(userId);
        return pushResult;
    }
}
