package com.walker.queue;

import com.walker.async.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

public abstract class AbstractQueueManager implements QueueManager {

	protected final transient Logger logger = LoggerFactory.getLogger(getClass());

	private int id = 0;
	private String name = "未命名队列管理器";

	protected int maxWorkerThread = 8;

	public int getMaxWorkerThread() {
		return maxWorkerThread;
	}

	/**
	 * 设置工作线程最大数量，默认：8个
	 * @param maxWorkerThread
	 */
	public void setMaxWorkerThread(int maxWorkerThread) {
		this.maxWorkerThread = maxWorkerThread;
	}


	public void setName(String name) {
		this.name = name;
	}

	public void setId(int id) {
		this.id = id;
	}

	@Override
	public int getId() {
		return id;
	}

	@Override
	public String getName() {
		return this.name;
	}

//	@Override
//	public void push(String key, Object data, Object option) throws QueueException {
//
//	}

	@Override
	public void setConsumers(List<Consumer> consumerList) {

	}

}
