package com.walker.spider;

/**
 * 文本解析器定义。
 * <p>把给定的输入内容，解析为定义的形式。</p>
 * <pre>
 *     1) T 最终返回的数据结果
 *     2) K 提供的选项条件，例如：你想要的字段名称等
 * </pre>
 * @author 时克英
 * @date 2023-04-26
 */
public interface TextParse<T, K> {

    /**
     * 返回数据分隔符
     * @return
     */
    String getDelimiter();

    /**
     * 解析分析方法
     * @param content 原始数据
     * @param option 您的条件
     * @return 返回结果
     */
    T parse(Object content, K option);
}
