/*
 * Decompiled with CFR 0.152.
 */
package com.walker.db;

import com.walker.infrastructure.utils.StringUtils;

public abstract class Sorts {
    public static final String NAME_ASC = "asc";
    public static final String NAME_DESC = "desc";

    public static Sort ASC() {
        return new AscSort();
    }

    public static Sort DESC() {
        return new DescSort();
    }

    public static void main(String[] args) {
        Sorts.ASC().setField("sxh");
    }

    private static class AscSort
    implements Sort {
        private String fieldName;

        private AscSort() {
        }

        @Override
        public String getValue() {
            return Sorts.NAME_ASC;
        }

        @Override
        public String getField() {
            return this.fieldName;
        }

        @Override
        public Sort setField(String name) {
            assert (StringUtils.isNotEmpty(name));
            this.fieldName = name;
            return this;
        }

        @Override
        public boolean isAsc() {
            return true;
        }
    }

    private static class DescSort
    implements Sort {
        private String fieldName;

        private DescSort() {
        }

        @Override
        public String getValue() {
            return Sorts.NAME_DESC;
        }

        @Override
        public String getField() {
            return this.fieldName;
        }

        @Override
        public Sort setField(String name) {
            assert (StringUtils.isNotEmpty(name));
            this.fieldName = name;
            return this;
        }

        @Override
        public boolean isAsc() {
            return false;
        }
    }

    public static interface Sort {
        public String getValue();

        public String getField();

        public Sort setField(String var1);

        public boolean isAsc();
    }
}

