/*
 * Decompiled with CFR 0.152.
 */
package com.walker.db.page;

import com.walker.db.page.GenericPager;
import com.walker.db.page.MapPager;
import com.walker.db.page.PageSearch;
import com.walker.db.page.PagerView;
import com.walker.infrastructure.core.NamedThreadLocal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ListPageContext {
    private static final transient Logger logger = LoggerFactory.getLogger(ListPageContext.class);
    public static final String PARAM_NAME_PAGE_INDEX = "walker_page_index";
    public static final String PARAM_NAME_PAGE_SIZE = "walker_page_size";
    public static final int DEFAULT_PAGE_SIZE = 1;
    private static final NamedThreadLocal<Integer> pageIndexLocals = new NamedThreadLocal("pageIndexThreadLocal");
    private static final NamedThreadLocal<Integer> pageSizeLocals = new NamedThreadLocal("pageSizeThreadLocal");
    private static final NamedThreadLocal<PageSearch> pageSearchLocals = new NamedThreadLocal("pageSearchThreadLocal");

    public static final int getCurrentPageIndex() {
        Integer val = (Integer)pageIndexLocals.get();
        if (val == null) {
            return 1;
        }
        return val;
    }

    public static final int getCurrentPageSize() {
        Integer val = (Integer)pageSizeLocals.get();
        if (val == null) {
            return 1;
        }
        return val;
    }

    public static void setCurrentPageIndex(int pageIndex) {
        Integer _old = (Integer)pageIndexLocals.get();
        if (logger.isDebugEnabled() && _old != null) {
            logger.debug("exist pageIndex in '" + pageIndexLocals + "' : " + _old);
        }
        pageIndexLocals.set(pageIndex);
    }

    public static void setCurrentPageSize(int pageSize) {
        Integer _old = (Integer)pageSizeLocals.get();
        if (logger.isDebugEnabled() && _old != null) {
            logger.debug("exist pageIndex in '" + pageSizeLocals + "' : " + _old);
        }
        pageSizeLocals.set(pageSize);
    }

    public static void clearCurrentPageIndex() {
        pageIndexLocals.remove();
    }

    public static void clearCurrentPageSize() {
        pageSizeLocals.remove();
    }

    public static final PageSearch getPageSearch() {
        return (PageSearch)pageSearchLocals.get();
    }

    public static final void setPageSearch(PageSearch pageSearch) {
        pageSearchLocals.set(pageSearch);
    }

    public static final void clearPageSearch() {
        pageSearchLocals.remove();
    }

    public static final <T> GenericPager<T> createGenericPager(List<T> datas, int pageIndex, int pageSize, int totalRows) {
        return new GenericPager<T>(datas, ListPageContext.getContextPageIndex(pageIndex), ListPageContext.getContextPageSize(pageSize), totalRows);
    }

    public static final <T> GenericPager<T> createGenericPager(List<T> datas, int pageIndex, int totalRows) {
        return new GenericPager<T>(datas, ListPageContext.getContextPageIndex(pageIndex), ListPageContext.getContextPageSize(0), totalRows);
    }

    public static final <T> GenericPager<T> createGenericPager(int pageIndex, int pageSize, int totalRows) {
        return new GenericPager(null, ListPageContext.getContextPageIndex(pageIndex), ListPageContext.getContextPageSize(pageSize), totalRows);
    }

    public static final <T> GenericPager<T> createEmptyGenericPager() {
        return new GenericPager(null, 1, ListPageContext.getContextPageSize(0), 0);
    }

    public static final MapPager createMapPager(List<Map<String, Object>> datas, int pageIndex, int pageSize, int totalRows) {
        return new MapPager(datas, ListPageContext.getContextPageIndex(pageIndex), ListPageContext.getContextPageSize(pageSize), totalRows);
    }

    public static final MapPager createMapPager(List<Map<String, Object>> datas, int pageIndex, int totalRows) {
        return new MapPager(datas, ListPageContext.getContextPageIndex(pageIndex), ListPageContext.getContextPageSize(0), totalRows);
    }

    public static final <T> PagerView<T> createPagerView(GenericPager<T> pager, String jsMethod) {
        return new PagerView(pager, jsMethod);
    }

    private static int getContextPageSize(int pageSizeValue) {
        Integer _val = (Integer)pageSizeLocals.get();
        if (_val != null) {
            return _val;
        }
        if (pageSizeValue <= 0) {
            return 1;
        }
        return pageSizeValue;
    }

    private static int getContextPageIndex(int pageIndexValue) {
        Integer pageIndex = (Integer)pageIndexLocals.get();
        if (pageIndex != null) {
            return pageIndex;
        }
        if (pageIndexValue <= 0) {
            return 1;
        }
        return pageIndexValue;
    }
}

